/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import jruby.objectweb.asm.Type;
import org.jruby.Ruby;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.compiler.NotCompilableException;
import org.jruby.evaluator.Instruction;
import org.jruby.internal.runtime.methods.MultiStub;
import org.jruby.internal.runtime.methods.MultiStubMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.util.JRubyClassLoader;

public class InstructionCompiler2
implements NodeVisitor {
    private static final String RUBYMODULE = "org/jruby/RubyModule";
    private static final String RUBY = "org/jruby/Ruby";
    private static final String IRUBYOBJECT = "org/jruby/runtime/builtin/IRubyObject";
    private static final String THREADCONTEXT = "org/jruby/runtime/ThreadContext";
    private static final boolean EXPERIMENTAL_SOURCING = true;
    private ArgsNode args;
    private ClassWriter cv;
    private MethodVisitor mv;
    private int lastLine = 0;
    private boolean runtimeLoaded;
    Map classWriters = new HashMap();
    ClassWriter currentMultiStub = null;
    int multiStubIndex = -1;
    int multiStubCount = -1;
    private String classname;
    private String sourceName;

    public void closeOutMultiStub() {
        if (this.currentMultiStub != null) {
            while (this.multiStubIndex < 9) {
                MethodVisitor multiStubMethod = this.createNewMethod();
                multiStubMethod.visitCode();
                multiStubMethod.visitInsn(1);
                multiStubMethod.visitInsn(176);
                multiStubMethod.visitMaxs(1, 1);
                multiStubMethod.visitEnd();
            }
        }
    }

    public void defineModuleFunction(Ruby runtime, String module, String name, MultiStub stub, int index, Arity arity, Visibility visibility) {
        runtime.getModule(module).addMethod(name, new MultiStubMethod(stub, index, runtime.getModule(module), arity, visibility));
    }

    public String[] compile(String classname, String sourceName, Node node) {
        this.cv = new ClassWriter(true);
        if (classname.startsWith("-e")) {
            classname = classname.replaceAll("-e", "DashE");
        }
        this.classWriters.put(classname, this.cv);
        this.classname = classname;
        this.sourceName = sourceName;
        this.cv.visit(46, 33, classname, null, "java/lang/Object", new String[]{"org/jruby/ast/executable/Script"});
        this.cv.visitSource(sourceName, null);
        this.mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        this.mv.visitCode();
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        this.mv.visitInsn(177);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
        this.mv = this.createNewMethod();
        String className = classname + "$MultiStub" + this.multiStubCount;
        String methodName = "method" + this.multiStubIndex;
        this.mv.visitCode();
        node.accept(this);
        this.mv.visitInsn(176);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
        this.runtimeLoaded = false;
        this.closeOutMultiStub();
        this.mv = this.cv.visitMethod(1, "run", "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;", null, null);
        this.mv.visitTypeInsn(187, className);
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, className, "<init>", "()V");
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitInsn(1);
        this.mv.visitMethodInsn(182, className, methodName, "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitInsn(176);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
        return new String[]{className, methodName};
    }

    public Class loadClasses(JRubyClassLoader loader) throws ClassNotFoundException {
        Iterator iter = this.classWriters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            ClassWriter writer = (ClassWriter)entry.getValue();
            loader.defineClass(key.replaceAll("/", "."), writer.toByteArray());
        }
        return loader.loadClass(this.classname.replaceAll("/", "."));
    }

    public Instruction visitAliasNode(AliasNode iVisited) {
        this.lineNumber(iVisited);
        this.getRubyClass();
        this.mv.visitInsn(89);
        this.mv.visitInsn(89);
        Label l1 = new Label();
        this.mv.visitJumpInsn(199, l1);
        this.newTypeError("no class to make alias");
        this.mv.visitInsn(191);
        this.mv.visitLabel(l1);
        this.loadThreadContext();
        this.defineAlias(iVisited.getNewName(), iVisited.getOldName());
        this.mv.visitLdcInsn("method_added");
        this.newSymbol(iVisited.getNewName());
        this.invokeRubyModule("callMethod", "(Lorg/jruby/runtime/ThreadContext;Ljava/lang/String;Lorg/jruby/RubySymbol;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    private void newSymbol(String name) {
        this.loadRuntime();
        this.mv.visitLdcInsn(name);
        this.invokeRuby("newSymbol", "()Lorg/jruby/RubySymbol;");
    }

    private void defineAlias(String newName, String oldName) {
        this.mv.visitLdcInsn(newName);
        this.mv.visitLdcInsn(oldName);
        this.invokeRubyModule("defineAlias", "(Ljava/lang/String;Ljava/lang/String;)V");
    }

    private void newTypeError(String error) {
        this.loadRuntime();
        this.mv.visitLdcInsn(error);
        this.invokeRuby("newTypeError", "(Ljava/lang/String;)Lorg/jruby/exceptions/RaiseException;");
    }

    public Instruction visitAndNode(AndNode iVisited) {
        this.lineNumber(iVisited);
        iVisited.getFirstNode().accept(this);
        this.mv.visitInsn(89);
        this.invokeIRubyObject("isTrue", "()B");
        Label l1 = new Label();
        this.mv.visitJumpInsn(153, l1);
        this.mv.visitInsn(87);
        iVisited.getSecondNode().accept(this);
        this.mv.visitLabel(l1);
        return null;
    }

    private void invokeIRubyObject(String methodName, String signature) {
        this.mv.visitMethodInsn(185, IRUBYOBJECT, methodName, signature);
    }

    private void invokeRuby(String methodName, String signature) {
        this.mv.visitMethodInsn(182, RUBY, methodName, signature);
    }

    private void invokeThreadContext(String methodName, String signature) {
        this.mv.visitMethodInsn(182, THREADCONTEXT, methodName, signature);
    }

    private void invokeRubyModule(String methodName, String signature) {
        this.mv.visitMethodInsn(182, RUBYMODULE, methodName, signature);
    }

    public Instruction visitArgsNode(ArgsNode iVisited) {
        return null;
    }

    public Instruction visitArgsCatNode(ArgsCatNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitArrayNode(ArrayNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        ValueCallback callback = new ValueCallback(){

            public void putValueOnStack(Object sourceArray, int index) {
                Node node = (Node)((Object[])sourceArray)[index];
                node.accept(InstructionCompiler2.this);
            }
        };
        this.buildObjectArray(IRUBYOBJECT, iVisited.childNodes().toArray(), callback);
        this.invokeRuby("newArray", "([Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/RubyArray;");
        return null;
    }

    private void buildObjectArray(String type, Object[] sourceArray, ValueCallback callback) {
        this.mv.visitLdcInsn(new Integer(sourceArray.length));
        this.mv.visitTypeInsn(189, type);
        for (int i = 0; i < sourceArray.length; ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(new Integer(i));
            callback.putValueOnStack(sourceArray, i);
            this.mv.visitInsn(83);
            ++i;
        }
    }

    private void buildPrimitiveArray(Type type, Object sourceArray, int length, ValueCallback callback) {
        this.mv.visitLdcInsn(new Integer(length));
        this.mv.visitTypeInsn(188, type.getDescriptor());
        for (int i = 0; i < length; ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(new Integer(i));
            callback.putValueOnStack(sourceArray, i);
            if (type.equals(Type.BYTE_TYPE) || type.equals(Type.BOOLEAN_TYPE)) {
                this.mv.visitInsn(84);
            } else if (type.equals(Type.CHAR_TYPE)) {
                this.mv.visitInsn(85);
            } else if (type.equals(Type.INT_TYPE)) {
                this.mv.visitInsn(79);
            } else if (type.equals(Type.LONG_TYPE)) {
                this.mv.visitInsn(80);
            } else if (type.equals(Type.FLOAT_TYPE)) {
                this.mv.visitInsn(81);
            } else if (type.equals(Type.DOUBLE_TYPE)) {
                this.mv.visitInsn(82);
            }
            ++i;
        }
    }

    public Instruction visitArgsPushNode(ArgsPushNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitAttrAssignNode(AttrAssignNode iVisited) {
        this.lineNumber(iVisited);
        this.loadThreadContext();
        this.invokeThreadContext("beginCallArgs", "()V");
        iVisited.getReceiverNode().accept(this);
        this.setupArgs(iVisited.getArgsNode());
        this.loadThreadContext();
        this.invokeThreadContext("endCallArgs", "()V");
        this.mv.visitInsn(95);
        this.mv.visitInsn(89);
        this.loadThreadContext();
        this.invokeThreadContext("getFrameSelf", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        Label l1 = new Label();
        Label l2 = new Label();
        this.mv.visitJumpInsn(165, l1);
        this.mv.visitFieldInsn(178, "org/jruby/runtime/CallType", "NORMAL", "Lorg/jruby/runtime/CallType;");
        this.mv.visitJumpInsn(167, l2);
        this.mv.visitLabel(l1);
        this.mv.visitFieldInsn(178, "org/jruby/runtime/CallType", "VARIABLE", "Lorg/jruby/runtime/CallType;");
        this.mv.visitLabel(l2);
        this.mv.visitInsn(95);
        this.loadThreadContext();
        this.mv.visitInsn(94);
        this.mv.visitInsn(88);
        this.mv.visitLdcInsn(iVisited.getName());
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.invokeIRubyObject("callMethod", "(Lorg/jruby/runtime/ThreadContext;Ljava/lang/String;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/CallType;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitBackRefNode(BackRefNode iVisited) {
        this.loadThreadContext();
        this.mv.visitMethodInsn(182, THREADCONTEXT, "getBackref", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        Label l1 = new Label();
        Label l2 = new Label();
        Label l3 = new Label();
        Label l4 = new Label();
        Label l5 = new Label();
        Label lafter = new Label();
        this.mv.visitLookupSwitchInsn(lafter, new int[]{126, 38, 96, 92, 43}, new Label[]{l1, l2, l3, l4, l5});
        this.mv.visitLabel(l1);
        this.mv.visitJumpInsn(167, lafter);
        this.mv.visitLabel(l2);
        this.mv.visitMethodInsn(184, "org/jruby/RubyRegexp", "last_match", "(Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitJumpInsn(167, lafter);
        this.mv.visitLabel(l3);
        this.mv.visitMethodInsn(184, "org/jruby/RubyRegexp", "match_pre", "(Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitJumpInsn(167, lafter);
        this.mv.visitLabel(l4);
        this.mv.visitMethodInsn(184, "org/jruby/RubyRegexp", "match_post", "(Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitJumpInsn(167, lafter);
        this.mv.visitLabel(l5);
        this.mv.visitMethodInsn(184, "org/jruby/RubyRegexp", "match_last", "(Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitLabel(lafter);
        return null;
    }

    public Instruction visitBeginNode(BeginNode iVisited) {
        iVisited.getBodyNode().accept(this);
        return null;
    }

    public Instruction visitBignumNode(BignumNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.mv.visitTypeInsn(187, "java/math/BigInteger");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn(iVisited.getValue().toString());
        this.mv.visitMethodInsn(183, "java/math/BigInteger", "<init>", "(Ljava/lang/String;)V");
        this.mv.visitMethodInsn(184, "org/jruby/RubyBignum", "newBignum", "(Lorg/jruby/Ruby;Ljava/math/BigInteger;)Lorg/jruby/RubyBignum;");
        return null;
    }

    public Instruction visitBlockArgNode(BlockArgNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitBlockNode(BlockNode iVisited) {
        this.lineNumber(iVisited);
        Iterator iter = iVisited.childNodes().iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            n.accept(this);
            if (!iter.hasNext()) continue;
            this.mv.visitInsn(87);
        }
        return null;
    }

    public Instruction visitBlockPassNode(BlockPassNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitBreakNode(BreakNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitConstDeclNode(ConstDeclNode iVisited) {
        this.lineNumber(iVisited);
        iVisited.getValueNode().accept(this);
        if (iVisited.getConstNode() != null) {
            iVisited.getConstNode().accept(this);
        } else {
            this.getRubyClass();
            Label l1 = new Label();
            this.mv.visitJumpInsn(199, l1);
            this.newTypeError("no class/module to define constant");
            this.mv.visitInsn(191);
            this.mv.visitLabel(l1);
            this.peekCRef();
        }
        this.mv.visitTypeInsn(192, RUBYMODULE);
        this.mv.visitInsn(95);
        this.mv.visitLdcInsn(iVisited.getName());
        this.mv.visitInsn(95);
        this.invokeRubyModule("setConstant", "(Ljava/lang/String;Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    private void peekCRef() {
        this.loadThreadContext();
        this.invokeThreadContext("peekCRef", "()Lorg/jruby/util/collections/SinglyLinkedList;");
        this.mv.visitMethodInsn(182, "org/jruby/util/collections/SingleLinkedList", "getValue", "()Ljava/lang/Object;");
    }

    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.lineNumber(iVisited);
        iVisited.getValueNode().accept(this);
        this.getCRefClass();
        this.mv.visitInsn(89);
        Label l1 = new Label();
        Label l2 = new Label();
        this.mv.visitJumpInsn(199, l1);
        this.mv.visitInsn(87);
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", "()Lorg/jruby/RubyClass;");
        this.mv.visitJumpInsn(167, l2);
        this.mv.visitLabel(l1);
        this.mv.visitInsn(89);
        this.invokeRubyModule("isSingleton", "()Z");
        this.mv.visitJumpInsn(153, l2);
        this.mv.visitLdcInsn("__attached__");
        this.invokeIRubyObject("getInstanceVariable", "(Ljava/lang/String;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitTypeInsn(192, RUBYMODULE);
        this.mv.visitLabel(l2);
        this.mv.visitInsn(95);
        this.mv.visitLdcInsn(iVisited.getName());
        this.mv.visitInsn(95);
        this.invokeRubyModule("setClassVar", "(Ljava/lang/String;Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        this.lineNumber(iVisited);
        this.getRubyClass();
        Label l298 = new Label();
        this.mv.visitJumpInsn(199, l298);
        this.newTypeError("no class/module to define class variable");
        this.mv.visitInsn(191);
        this.mv.visitLabel(l298);
        this.getCRefClass();
        this.mv.visitLdcInsn(iVisited.getName());
        iVisited.getValueNode().accept(this);
        this.invokeRubyModule("setClassVar", "(Ljava/lang/String;Lorg/jruby/runtime/builtin/IRubyObject;)V");
        this.loadRuntime();
        this.invokeRuby("getNil", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitClassVarNode(ClassVarNode iVisited) {
        this.lineNumber(iVisited);
        this.getCRefClass();
        this.mv.visitInsn(89);
        Label l1 = new Label();
        Label l2 = new Label();
        this.mv.visitJumpInsn(199, l1);
        this.mv.visitInsn(87);
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", "()Lorg/jruby/RubyClass;");
        this.mv.visitJumpInsn(167, l2);
        this.mv.visitLabel(l1);
        this.mv.visitInsn(89);
        this.invokeRubyModule("isSingleton", "()Z");
        this.mv.visitJumpInsn(153, l2);
        this.mv.visitLdcInsn("__attached__");
        this.invokeIRubyObject("getInstanceVariable", "(Ljava/lang/String;)Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitTypeInsn(192, RUBYMODULE);
        this.mv.visitLabel(l2);
        this.mv.visitLdcInsn(iVisited.getName());
        this.invokeRubyModule("getClassVar", "(Ljava/lang/String;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitCallNode(CallNode iVisited) {
        this.lineNumber(iVisited);
        this.loadThreadContext();
        this.invokeThreadContext("beginCallArgs", "()V");
        iVisited.getReceiverNode().accept(this);
        this.setupArgs(iVisited.getArgsNode());
        this.loadThreadContext();
        this.invokeThreadContext("endCallArgs", "()V");
        this.mv.visitInsn(95);
        this.mv.visitInsn(89);
        this.loadThreadContext();
        this.invokeThreadContext("getFrameSelf", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        Label l1 = new Label();
        Label l2 = new Label();
        this.mv.visitJumpInsn(165, l1);
        this.mv.visitFieldInsn(178, "org/jruby/runtime/CallType", "NORMAL", "Lorg/jruby/runtime/CallType;");
        this.mv.visitJumpInsn(167, l2);
        this.mv.visitLabel(l1);
        this.mv.visitFieldInsn(178, "org/jruby/runtime/CallType", "VARIABLE", "Lorg/jruby/runtime/CallType;");
        this.mv.visitLabel(l2);
        this.mv.visitInsn(95);
        this.loadThreadContext();
        this.mv.visitInsn(94);
        this.mv.visitInsn(88);
        this.mv.visitLdcInsn(iVisited.getName());
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.invokeIRubyObject("callMethod", "(Lorg/jruby/runtime/ThreadContext;Ljava/lang/String;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/CallType;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitCaseNode(CaseNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitColon2Node(Colon2Node iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitColon3Node(Colon3Node iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitConstNode(ConstNode iVisited) {
        this.lineNumber(iVisited);
        this.loadThreadContext();
        this.mv.visitLdcInsn(iVisited.getName());
        this.invokeThreadContext("getConstant", "(Ljava/lang/String;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitDAsgnNode(DAsgnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDRegxNode(DRegexpNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDStrNode(DStrNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDSymbolNode(DSymbolNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDVarNode(DVarNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDXStrNode(DXStrNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDefinedNode(DefinedNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public MethodVisitor createNewMethod() {
        if (this.currentMultiStub == null || this.multiStubIndex == 9) {
            if (this.currentMultiStub != null) {
                this.currentMultiStub.visitEnd();
            }
            ++this.multiStubCount;
            this.currentMultiStub = new ClassWriter(true);
            this.currentMultiStub.visit(46, 41, this.classname + "$MultiStub" + this.multiStubCount, null, "java/lang/Object", new String[]{"org/jruby/internal/runtime/methods/MultiStub"});
            this.cv.visitInnerClass(this.classname + "$MultiStub" + this.multiStubCount, this.classname, "MultiStub" + this.multiStubCount, 9);
            this.multiStubIndex = 0;
            this.classWriters.put(this.classname + "$MultiStub" + this.multiStubCount, this.currentMultiStub);
            this.currentMultiStub.visitSource(this.sourceName, null);
            MethodVisitor stubConstructor = this.currentMultiStub.visitMethod(1, "<init>", "()V", null, null);
            stubConstructor.visitCode();
            stubConstructor.visitVarInsn(25, 0);
            stubConstructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            stubConstructor.visitInsn(177);
            stubConstructor.visitMaxs(1, 1);
            stubConstructor.visitEnd();
        } else {
            ++this.multiStubIndex;
        }
        return this.currentMultiStub.visitMethod(1, "method" + this.multiStubIndex, "(Lorg/jruby/runtime/ThreadContext;Lorg/jruby/runtime/builtin/IRubyObject;[Lorg/jruby/runtime/builtin/IRubyObject;)Lorg/jruby/runtime/builtin/IRubyObject;", null, null);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        MethodVisitor oldMethod = this.mv;
        boolean oldRuntimeLoaded = this.runtimeLoaded;
        this.runtimeLoaded = false;
        this.mv = this.createNewMethod();
        this.mv.visitCode();
        this.args = iVisited.getArgsNode();
        this.mv.visitLdcInsn(new Integer(iVisited.getScope().getNumberOfVariables()));
        this.mv.visitTypeInsn(189, IRUBYOBJECT);
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(58, 4);
        this.mv.visitVarInsn(25, 3);
        this.mv.visitInsn(95);
        this.mv.visitLdcInsn(new Integer(0));
        this.mv.visitInsn(95);
        this.mv.visitLdcInsn(new Integer(0));
        this.mv.visitLdcInsn(new Integer(this.args.getArity().getValue()));
        this.mv.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V");
        iVisited.getBodyNode().accept(this);
        this.mv.visitMaxs(1, 1);
        this.mv.visitInsn(176);
        this.mv.visitEnd();
        this.runtimeLoaded = oldRuntimeLoaded;
        this.mv = oldMethod;
        this.getRubyClass();
        Label l335 = new Label();
        this.mv.visitJumpInsn(199, l335);
        this.newTypeError("No class to add method.");
        this.mv.visitInsn(191);
        this.mv.visitLabel(l335);
        Label l338 = new Label();
        if (iVisited.getName().equals("initialize")) {
            this.getRubyClass();
            this.loadRuntime();
            this.invokeRuby("getObject", "()Lorg/jruby/RubyClass;");
            this.mv.visitJumpInsn(166, l338);
            this.loadRuntime();
            this.invokeRuby("getWarnings", "()Lorg/jruby/common/RubyWarnings;");
            this.mv.visitLdcInsn("redefining Object#initialize may cause infinite loop");
            this.mv.visitMethodInsn(182, "org/jruby/common/RubyWarnings", "warn", "(Ljava/lang/String;)V");
        }
        this.mv.visitLabel(l338);
        this.getRubyClass();
        this.mv.visitTypeInsn(187, "org/jruby/internal/runtime/methods/MultiStubMethod");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, this.classname + "$MultiStub" + this.multiStubCount);
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, this.classname + "$MultiStub" + this.multiStubCount, "<init>", "()V");
        this.mv.visitLdcInsn(new Integer(this.multiStubIndex));
        this.getRubyClass();
        this.mv.visitLdcInsn(new Integer(this.args.getArity().getValue()));
        this.mv.visitMethodInsn(184, "org/jruby/runtime/Arity", "createArity", "(I)Lorg/jruby/runtime/Arity;");
        this.getCurrentVisibility();
        this.mv.visitMethodInsn(183, "org/jruby/internal/runtime/methods/MultiStubMethod", "<init>", "(Lorg/jruby/internal/runtime/methods/MultiStub;ILorg/jruby/RubyModule;Lorg/jruby/runtime/Arity;Lorg/jruby/runtime/Visibility;)V");
        this.mv.visitLdcInsn(iVisited.getName());
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, RUBYMODULE, "addMethod", "(Ljava/lang/String;Lorg/jruby/runtime/ICallable;)V");
        this.loadRuntime();
        this.invokeRuby("getNil", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    private void getCurrentVisibility() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentVisibility", "()Lorg/jruby/runtime/Visibility;");
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitDotNode(DotNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitEnsureNode(EnsureNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitEvStrNode(EvStrNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        this.lineNumber(iVisited);
        this.loadThreadContext();
        this.invokeThreadContext("getFrameSelf", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitLdcInsn(iVisited.getName());
        this.loadThreadContext();
        this.invokeThreadContext("beginCallArgs", "()V");
        this.setupArgs(iVisited.getArgsNode());
        this.loadThreadContext();
        this.invokeThreadContext("endCallArgs", "()V");
        this.loadThreadContext();
        this.mv.visitInsn(91);
        this.mv.visitInsn(87);
        this.mv.visitFieldInsn(178, "org/jruby/runtime/CallType", "FUNCTIONAL", "Lorg/jruby/runtime/CallType;");
        this.invokeIRubyObject("callMethod", "(Lorg/jruby/runtime/ThreadContext;Ljava/lang/String;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/CallType;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitFalseNode(FalseNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.invokeRuby("getFalse", "()Lorg/jruby/RubyBoolean;");
        return null;
    }

    public Instruction visitFixnumNode(FixnumNode iVisited) {
        this.lineNumber(iVisited);
        this.loadThreadContext();
        this.mv.visitMethodInsn(182, THREADCONTEXT, "getRuntime", "()Lorg/jruby/Ruby;");
        this.mv.visitLdcInsn(new Long(iVisited.getValue()));
        this.invokeRuby("newFixnum", "(J)Lorg/jruby/RubyFixnum;");
        return null;
    }

    public Instruction visitFlipNode(FlipNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitFloatNode(FloatNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.mv.visitLdcInsn(new Double(iVisited.getValue()));
        this.mv.visitMethodInsn(184, "org/jruby/RubyFloat", "newFloat", "(Lorg/jruby/Ruby;D)Lorg/jruby/RubyFloat;");
        return null;
    }

    public Instruction visitForNode(ForNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitGlobalVarNode(GlobalVarNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitHashNode(HashNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitInstAsgnNode(InstAsgnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitInstVarNode(InstVarNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitIfNode(IfNode iVisited) {
        this.lineNumber(iVisited);
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        iVisited.getCondition().accept(this);
        this.invokeIRubyObject("isTrue", "()Z");
        this.mv.visitJumpInsn(153, falseJmp);
        iVisited.getThenBody().accept(this);
        this.mv.visitJumpInsn(167, afterJmp);
        this.mv.visitLabel(falseJmp);
        iVisited.getElseBody().accept(this);
        this.mv.visitLabel(afterJmp);
        return null;
    }

    public Instruction visitIterNode(IterNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.lineNumber(iVisited);
        iVisited.getValueNode().accept(this);
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, 4);
        this.mv.visitInsn(95);
        this.mv.visitLdcInsn(new Integer(iVisited.getIndex()));
        this.mv.visitInsn(95);
        this.mv.visitInsn(83);
        return null;
    }

    public Instruction visitLocalVarNode(LocalVarNode iVisited) {
        this.lineNumber(iVisited);
        int index = iVisited.getIndex();
        if (this.args != null && index - 2 < this.args.getArgsCount()) {
            this.mv.visitVarInsn(25, 3);
            this.mv.visitLdcInsn(new Integer(index - 2));
            this.mv.visitInsn(50);
        } else {
            this.mv.visitVarInsn(25, 4);
            this.mv.visitLdcInsn(new Integer(iVisited.getIndex()));
            this.mv.visitInsn(50);
        }
        return null;
    }

    public Instruction visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitMatch2Node(Match2Node iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitMatch3Node(Match3Node iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitMatchNode(MatchNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitNewlineNode(NewlineNode iVisited) {
        iVisited.getNextNode().accept(this);
        return null;
    }

    public Instruction visitNextNode(NextNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitNilNode(NilNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.invokeRuby("getNil", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitNotNode(NotNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        iVisited.getConditionNode().accept(this);
        this.invokeIRubyObject("isTrue", "()B");
        Label l1 = new Label();
        Label l2 = new Label();
        this.mv.visitJumpInsn(153, l1);
        this.invokeRuby("getFalse", "()Lorg/jruby/RubyBoolean;");
        this.mv.visitLabel(l1);
        this.invokeRuby("getTrue", "()Lorg/jruby/RubyBoolean;");
        this.mv.visitLabel(l2);
        return null;
    }

    public Instruction visitNthRefNode(NthRefNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitOpAsgnNode(OpAsgnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitOpAsgnAndNode(OpAsgnAndNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitOpAsgnOrNode(OpAsgnOrNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitOptNNode(OptNNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitOrNode(OrNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitPostExeNode(PostExeNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitRedoNode(RedoNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitRegexpNode(RegexpNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitRescueBodyNode(RescueBodyNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitRescueNode(RescueNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitRetryNode(RetryNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitReturnNode(ReturnNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.mv.visitLdcInsn(new Integer(iVisited.getStaticScope().getNumberOfVariables()));
        this.mv.visitTypeInsn(189, IRUBYOBJECT);
        this.mv.visitVarInsn(58, 4);
        iVisited.getBodyNode().accept(this);
        return null;
    }

    public Instruction visitSClassNode(SClassNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitSelfNode(SelfNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitSplatNode(SplatNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitStrNode(StrNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.mv.visitLdcInsn(iVisited.getValue());
        this.invokeRuby("newString", "(Ljava/lang/String;)Lorg/jruby/RubyString;");
        return null;
    }

    public Instruction visitSuperNode(SuperNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitSValueNode(SValueNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitSymbolNode(SymbolNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitToAryNode(ToAryNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitTrueNode(TrueNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.invokeRuby("getTrue", "()Lorg/jruby/RubyBoolean;");
        return null;
    }

    public Instruction visitUndefNode(UndefNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitUntilNode(UntilNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.invokeRuby("getNil", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        if (iVisited.getBodyNode() != null) {
            Label l1 = new Label();
            Label l2 = new Label();
            this.mv.visitLabel(l1);
            iVisited.getConditionNode().accept(this);
            this.invokeIRubyObject("isTrue", "()Z");
            this.mv.visitJumpInsn(154, l2);
            iVisited.getBodyNode().accept(this);
            this.mv.visitInsn(87);
            this.mv.visitJumpInsn(167, l1);
            this.mv.visitLabel(l2);
        }
        return null;
    }

    public Instruction visitVAliasNode(VAliasNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        this.lineNumber(iVisited);
        this.loadSelf();
        this.loadThreadContext();
        this.mv.visitLdcInsn(iVisited.getName());
        this.mv.visitFieldInsn(178, IRUBYOBJECT, "NULL_ARRAY", "[Lorg/jruby/runtime/builtin/IRubyObject;");
        this.mv.visitFieldInsn(178, "org/jruby/runtime/CallType", "FUNCTIONAL", "Lorg/jruby/runtime/CallType;");
        this.invokeIRubyObject("callMethod", "(Lorg/jruby/runtime/ThreadContext;Ljava/lang/String;[Lorg/jruby/runtime/builtin/IRubyObject;Lorg/jruby/runtime/CallType;)Lorg/jruby/runtime/builtin/IRubyObject;");
        return null;
    }

    public Instruction visitWhenNode(WhenNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitWhileNode(WhileNode iVisited) {
        this.lineNumber(iVisited);
        this.loadRuntime();
        this.invokeRuby("getNil", "()Lorg/jruby/runtime/builtin/IRubyObject;");
        if (iVisited.getBodyNode() != null) {
            Label l1 = new Label();
            Label l2 = new Label();
            this.mv.visitLabel(l1);
            if (iVisited.evaluateAtStart()) {
                iVisited.getConditionNode().accept(this);
                this.invokeIRubyObject("isTrue", "()Z");
                this.mv.visitJumpInsn(153, l2);
            }
            iVisited.getBodyNode().accept(this);
            this.mv.visitInsn(87);
            if (!iVisited.evaluateAtStart()) {
                iVisited.getConditionNode().accept(this);
                this.invokeIRubyObject("isTrue", "()Z");
                this.mv.visitJumpInsn(154, l1);
            } else {
                this.mv.visitJumpInsn(167, l1);
            }
            this.mv.visitLabel(l2);
        }
        return null;
    }

    public Instruction visitXStrNode(XStrNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitYieldNode(YieldNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitZArrayNode(ZArrayNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    public Instruction visitZSuperNode(ZSuperNode iVisited) {
        throw new NotCompilableException("Node not supported: " + iVisited.toString());
    }

    private void lineNumber(Node iVisited) {
        this.lastLine = iVisited.getPosition().getEndLine();
        if (this.lastLine == this.lastLine) {
            return;
        }
        Label l = new Label();
        this.mv.visitLabel(l);
        this.mv.visitLineNumber(iVisited.getPosition().getEndLine(), l);
    }

    public Map getClassWriters() {
        return this.classWriters;
    }

    private void setupArgs(Node node) {
        if (node == null) {
            this.mv.visitInsn(3);
            this.mv.visitTypeInsn(189, IRUBYOBJECT);
        } else if (node instanceof ArrayNode) {
            this.lineNumber(node);
            int count = ((ArrayNode)node).size();
            this.mv.visitLdcInsn(new Integer(count));
            this.mv.visitTypeInsn(189, IRUBYOBJECT);
            int i = 0;
            Iterator iter = ((ArrayNode)node).iterator();
            while (iter.hasNext()) {
                Node next = (Node)iter.next();
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(new Integer(i));
                if (!(next instanceof SplatNode)) {
                    next.accept(this);
                }
                this.mv.visitInsn(83);
                ++i;
            }
        }
    }

    private void loadThreadContext() {
        this.mv.visitVarInsn(25, 1);
    }

    private void loadRuntime() {
        this.mv.visitVarInsn(25, 1);
        this.invokeThreadContext("getRuntime", "()Lorg/jruby/Ruby;");
    }

    private void loadSelf() {
        this.mv.visitVarInsn(25, 2);
    }

    private void getCRefClass() {
        this.loadThreadContext();
        this.invokeThreadContext("peekCRef", "()Lorg/jruby/util/collections/SinglyLinkedList;");
        this.mv.visitMethodInsn(182, "org/jruby/util/collections/SinglyLinkedList", "getValue", "()Ljava/lang/Object;");
        this.mv.visitTypeInsn(192, RUBYMODULE);
    }

    private void getRubyClass() {
        this.loadThreadContext();
        this.invokeThreadContext("getRubyClass", "()Lorg/jruby/RubyModule;");
    }

    private static interface ValueCallback {
        public void putValueOnStack(Object var1, int var2);
    }
}

