/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormat;

public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private Calendar cal;
    private long usec;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("-", Locale.US);

    public static TimeZone getLocalTimeZone(Ruby runtime) {
        RubyString tzVar = runtime.newString("TZ");
        Map h = ((RubyHash)runtime.getObject().getConstant("ENV")).getValueMap();
        IRubyObject tz = (IRubyObject)h.get(tzVar);
        if (tz == null || !(tz instanceof RubyString)) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(tz.toString());
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public RubyTime(Ruby runtime, RubyClass rubyClass, Calendar cal) {
        super(runtime, rubyClass);
        this.cal = cal;
    }

    public void setUSec(long usec) {
        this.usec = usec;
    }

    public void updateCal(Calendar calendar) {
        calendar.setTimeZone(this.cal.getTimeZone());
        calendar.setTimeInMillis(this.getTimeInMillis());
    }

    protected long getTimeInMillis() {
        return this.cal.getTimeInMillis();
    }

    public static RubyTime newTime(Ruby runtime, long milliseconds) {
        Calendar cal = Calendar.getInstance();
        RubyTime time = new RubyTime(runtime, runtime.getClass("Time"), cal);
        cal.setTimeInMillis(milliseconds);
        return time;
    }

    public static RubyTime newTime(Ruby runtime, Calendar cal) {
        RubyTime time = new RubyTime(runtime, runtime.getClass("Time"), cal);
        return time;
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw this.getRuntime().newTypeError("Expecting an instance of class Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.cal = originalTime.cal;
        this.usec = originalTime.usec;
        return this;
    }

    public RubyTime succ() {
        Calendar newCal = (Calendar)this.cal.clone();
        newCal.add(13, 1);
        return RubyTime.newTime(this.getRuntime(), newCal);
    }

    public RubyTime gmtime() {
        this.cal.setTimeZone(TimeZone.getTimeZone(UTC));
        return this;
    }

    public RubyTime localtime() {
        long dump = this.cal.getTimeInMillis();
        this.cal = Calendar.getInstance(RubyTime.getLocalTimeZone(this.getRuntime()));
        this.cal.setTimeInMillis(dump);
        return this;
    }

    public RubyBoolean gmt() {
        return this.getRuntime().newBoolean(this.cal.getTimeZone().getID().equals(UTC));
    }

    public RubyTime getgm() {
        Calendar newCal = (Calendar)this.cal.clone();
        newCal.setTimeZone(TimeZone.getTimeZone(UTC));
        return RubyTime.newTime(this.getRuntime(), newCal);
    }

    public RubyTime getlocal() {
        Calendar newCal = (Calendar)this.cal.clone();
        newCal.setTimeZone(RubyTime.getLocalTimeZone(this.getRuntime()));
        return RubyTime.newTime(this.getRuntime(), newCal);
    }

    public RubyString strftime(IRubyObject format) {
        RubyDateFormat rubyDateFormat = new RubyDateFormat("-", Locale.US);
        rubyDateFormat.setCalendar(this.cal);
        rubyDateFormat.applyPattern(format.toString());
        String result = rubyDateFormat.format(this.cal.getTime());
        return this.getRuntime().newString(result);
    }

    public IRubyObject op_ge(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) >= 0);
        }
        return RubyComparable.op_ge(this, other);
    }

    public IRubyObject op_gt(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) > 0);
        }
        return RubyComparable.op_gt(this, other);
    }

    public IRubyObject op_le(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) <= 0);
        }
        return RubyComparable.op_le(this, other);
    }

    public IRubyObject op_lt(IRubyObject other) {
        if (other instanceof RubyTime) {
            return this.getRuntime().newBoolean(this.cmp((RubyTime)other) < 0);
        }
        return RubyComparable.op_lt(this, other);
    }

    private int cmp(RubyTime other) {
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long usec_other = other.usec;
        if (millis > millis_other || millis == millis_other && this.usec > usec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && this.usec < usec_other) {
            return -1;
        }
        return 0;
    }

    public IRubyObject op_plus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            throw this.getRuntime().newTypeError("time + time ?");
        }
        time = (long)((double)time + ((RubyNumeric)other).getDoubleValue() * 1000.0);
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.cal = Calendar.getInstance();
        newTime.cal.setTimeZone(this.cal.getTimeZone());
        newTime.cal.setTime(new Date(time));
        return newTime;
    }

    public IRubyObject op_minus(IRubyObject other) {
        long time = this.getTimeInMillis();
        if (other instanceof RubyTime) {
            return RubyFloat.newFloat(this.getRuntime(), (double)(time -= ((RubyTime)other).getTimeInMillis()) * 0.001);
        }
        time = (long)((double)time - ((RubyNumeric)other).getDoubleValue() * 1000.0);
        RubyTime newTime = new RubyTime(this.getRuntime(), this.getMetaClass());
        newTime.cal = Calendar.getInstance();
        newTime.cal.setTimeZone(this.cal.getTimeZone());
        newTime.cal.setTime(new Date(time));
        return newTime;
    }

    public IRubyObject same2(IRubyObject other) {
        return RubyNumeric.fix2int(this.callMethod(this.getRuntime().getCurrentContext(), "<=>", other)) == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_cmp(IRubyObject other) {
        if (other.isNil()) {
            return other;
        }
        if (other instanceof RubyTime) {
            return this.getRuntime().newFixnum(this.cmp((RubyTime)other));
        }
        long millis = this.getTimeInMillis();
        if (other instanceof RubyNumeric) {
            if (other instanceof RubyFloat || other instanceof RubyBignum) {
                double time = (double)millis / 1000.0;
                double time_other = ((RubyNumeric)other).getDoubleValue();
                if (time > time_other) {
                    return RubyFixnum.one(this.getRuntime());
                }
                if (time < time_other) {
                    return RubyFixnum.minus_one(this.getRuntime());
                }
                return RubyFixnum.zero(this.getRuntime());
            }
            long millis_other = RubyNumeric.num2long(other) * 1000L;
            if (millis > millis_other || millis == millis_other && this.usec > 0L) {
                return RubyFixnum.one(this.getRuntime());
            }
            if (millis < millis_other || millis == millis_other && this.usec < 0L) {
                return RubyFixnum.minus_one(this.getRuntime());
            }
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    public RubyString asctime() {
        simpleDateFormat.setCalendar(this.cal);
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss yyyy");
        String result = simpleDateFormat.format(this.cal.getTime());
        return this.getRuntime().newString(result);
    }

    public IRubyObject to_s() {
        simpleDateFormat.setCalendar(this.cal);
        simpleDateFormat.applyPattern("EEE MMM dd HH:mm:ss z yyyy");
        String result = simpleDateFormat.format(this.cal.getTime());
        return this.getRuntime().newString(result);
    }

    public RubyArray to_a() {
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.zone()});
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuntime(), (double)(this.getTimeInMillis() / 1000L) + (double)this.microseconds() / 1000000.0);
    }

    public RubyInteger to_i() {
        return this.getRuntime().newFixnum(this.getTimeInMillis() / 1000L);
    }

    public RubyInteger usec() {
        return this.getRuntime().newFixnum(this.microseconds());
    }

    public void setMicroseconds(long mic) {
        long millis = this.getTimeInMillis() % 1000L;
        long withoutMillis = this.getTimeInMillis() - millis;
        this.cal.setTimeInMillis(withoutMillis += mic / 1000L);
        this.usec = mic % 1000L;
    }

    public long microseconds() {
        return this.getTimeInMillis() % 1000L * 1000L + this.usec;
    }

    public RubyInteger sec() {
        return this.getRuntime().newFixnum(this.cal.get(13));
    }

    public RubyInteger min() {
        return this.getRuntime().newFixnum(this.cal.get(12));
    }

    public RubyInteger hour() {
        return this.getRuntime().newFixnum(this.cal.get(11));
    }

    public RubyInteger mday() {
        return this.getRuntime().newFixnum(this.cal.get(5));
    }

    public RubyInteger month() {
        return this.getRuntime().newFixnum(this.cal.get(2) + 1);
    }

    public RubyInteger year() {
        return this.getRuntime().newFixnum(this.cal.get(1));
    }

    public RubyInteger wday() {
        return this.getRuntime().newFixnum(this.cal.get(7) - 1);
    }

    public RubyInteger yday() {
        return this.getRuntime().newFixnum(this.cal.get(6));
    }

    public RubyInteger gmt_offset() {
        return this.getRuntime().newFixnum(this.cal.get(15) / 1000);
    }

    public RubyBoolean isdst() {
        return this.getRuntime().newBoolean(this.cal.getTimeZone().inDaylightTime(this.cal.getTime()));
    }

    public RubyString zone() {
        return this.getRuntime().newString(this.cal.getTimeZone().getID());
    }

    public void setJavaCalendar(Calendar cal) {
        this.cal = cal;
    }

    public Date getJavaDate() {
        return this.cal.getTime();
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum((int)((this.cal.getTimeInMillis() / 1000L ^ this.microseconds()) << 1) >> 1);
    }

    public RubyString dump(IRubyObject[] args, Block unusedBlock) {
        if (args.length > 1) {
            throw this.getRuntime().newArgumentError(0, 1);
        }
        return (RubyString)this.mdump(new IRubyObject[]{this});
    }

    public RubyObject mdump(IRubyObject[] args) {
        int i;
        RubyTime obj = (RubyTime)args[0];
        Calendar calendar = obj.gmtime().cal;
        byte[] dumpValue = new byte[8];
        int pe = Integer.MIN_VALUE | calendar.get(1) - 1900 << 14 | calendar.get(2) << 10 | calendar.get(5) << 5 | calendar.get(11);
        int se = calendar.get(12) << 26 | calendar.get(13) << 20 | calendar.get(14);
        for (i = 0; i < 4; ++i) {
            dumpValue[i] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i = 4; i < 8; ++i) {
            dumpValue[i] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        return RubyString.newString(obj.getRuntime(), new ByteList(dumpValue, false));
    }
}

