/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyIconv
extends RubyObject {
    private static ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIconv(runtime, klass);
        }
    };

    public RubyIconv(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static void createIconv(Ruby runtime) {
        RubyClass iconvClass = runtime.defineClass("Iconv", runtime.getObject(), ICONV_ALLOCATOR);
        RubyClass argumentError = runtime.getClass("ArgumentError");
        iconvClass.defineClassUnder("IllegalSequence", argumentError, argumentError.getAllocator());
        iconvClass.defineClassUnder("InvalidCharacter", argumentError, argumentError.getAllocator());
        iconvClass.defineClassUnder("InvalidEncoding", argumentError, argumentError.getAllocator());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyIconv.class);
        iconvClass.getMetaClass().defineFastMethod("iconv", callbackFactory.getOptSingletonMethod("iconv"));
        iconvClass.getMetaClass().defineFastMethod("conv", callbackFactory.getOptSingletonMethod("conv"));
        iconvClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
    }

    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        this.checkArgumentCount(args, 2, 2);
        return this;
    }

    public static IRubyObject iconv(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(recv, args, "iconv");
    }

    public static IRubyObject conv(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyIconv.convertWithArgs(recv, args, "conv").join(recv.getRuntime().newString(""));
    }

    public static RubyArray convertWithArgs(IRubyObject recv, IRubyObject[] args, String function) {
        recv.checkArgumentCount(args, 3, -1);
        String fromEncoding = args[1].convertToString().toString();
        String toEncoding = args[0].convertToString().toString();
        RubyArray array = recv.getRuntime().newArray();
        for (int i = 2; i < args.length; ++i) {
            array.append(RubyIconv.convert2(fromEncoding, toEncoding, args[i].convertToString()));
        }
        return array;
    }

    private static IRubyObject convert2(String fromEncoding, String toEncoding, RubyString original) {
        try {
            byte[] bytes = original.getBytes();
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            CharsetDecoder decoder = Charset.forName(fromEncoding).newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer cbuf = decoder.decode(buf);
            CharsetEncoder encoder = Charset.forName(toEncoding).newEncoder();
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            buf = encoder.encode(cbuf);
            byte[] arr = buf.array();
            return RubyString.newString(original.getRuntime(), new ByteList(arr, 0, buf.limit()));
        }
        catch (UnsupportedCharsetException e) {
            throw original.getRuntime().newInvalidEncoding("invalid encoding");
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return original.getRuntime().getNil();
    }
}

