/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexpTranslator {
    private static final Pattern SHARP_IN_CHARACTER_CLASS_PATTERN = Pattern.compile("(\\[[^]]*)#(.*?])");
    private static final Pattern SPACE_IN_CHARACTER_CLASS_PATTERN = Pattern.compile("(\\[[^]]*) (.*?])");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("\\(\\?#[^)]*\\)");
    private static final Pattern HEX_SINGLE_DIGIT_PATTERN = Pattern.compile("\\\\x(\\p{XDigit})(?!\\p{XDigit})");
    private static final Pattern OCTAL_SINGLE_ZERO_PATTERN = Pattern.compile("\\\\(0)(?![0-7])");
    private static final Pattern OCTAL_MISSING_ZERO_PATTERN = Pattern.compile("\\\\([1-7][0-7]{1,2})");
    private static final Pattern POSIX_NAME = Pattern.compile("\\[:(\\w+):\\]");

    public Pattern translate(String regex, int options, int javaRegexFlags) throws PatternSyntaxException {
        regex = this.translatePattern(regex, ((javaRegexFlags |= this.translateFlags(options)) & 4) != 0);
        return Pattern.compile(regex, javaRegexFlags);
    }

    private String translatePosixPattern(String regex) {
        Matcher matcher = POSIX_NAME.matcher(regex);
        while (matcher.find()) {
            String value = matcher.group(1);
            regex = "alnum".equals(value) ? matcher.replaceFirst("\\\\p{Alnum}") : ("alpha".equals(value) ? matcher.replaceFirst("\\\\p{Alpha}") : ("blank".equals(value) ? matcher.replaceFirst("\\\\p{Blank}") : ("cntrl".equals(value) ? matcher.replaceFirst("\\\\p{Cntrl}") : ("digit".equals(value) ? matcher.replaceFirst("\\\\p{Digit}") : ("graph".equals(value) ? matcher.replaceFirst("\\\\p{Graph}") : ("lower".equals(value) ? matcher.replaceFirst("\\\\p{Lower}") : ("print".equals(value) ? matcher.replaceFirst("\\\\p{Print}") : ("punct".equals(value) ? matcher.replaceFirst("\\\\p{Punct}") : ("space".equals(value) ? matcher.replaceFirst("\\\\p{Space}") : ("upper".equals(value) ? matcher.replaceFirst("\\\\p{Upper}") : ("xdigit".equals(value) ? matcher.replaceFirst("\\\\p{XDigit}") : matcher.replaceFirst("\\\\[:" + value + ":\\\\]"))))))))))));
            matcher = POSIX_NAME.matcher(regex);
        }
        return regex;
    }

    String translatePattern(String regex, boolean commentsAllowed) {
        regex = COMMENT_PATTERN.matcher(regex).replaceAll("");
        regex = this.translatePosixPattern(regex);
        regex = HEX_SINGLE_DIGIT_PATTERN.matcher(regex).replaceAll("\\\\x0$1");
        regex = OCTAL_SINGLE_ZERO_PATTERN.matcher(regex).replaceAll("\\\\0$1");
        regex = OCTAL_MISSING_ZERO_PATTERN.matcher(regex).replaceAll("\\\\0$1");
        if (commentsAllowed) {
            regex = SPACE_IN_CHARACTER_CLASS_PATTERN.matcher(regex).replaceAll("$1\\\\x20$2");
            regex = SHARP_IN_CHARACTER_CLASS_PATTERN.matcher(regex).replaceAll("$1\\\\x23$2");
        }
        return regex;
    }

    int translateFlags(int options) {
        int flags = 8;
        if ((options & 1) > 0) {
            flags |= 2;
        }
        if ((options & 2) > 0) {
            flags |= 4;
        }
        if ((options & 4) > 0) {
            flags |= 0x20;
        }
        return flags;
    }
}

