/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;

public class InNode
extends Node {
    private final Node expression;
    private final Node body;
    private final Node nextCase;

    public InNode(int line, Node expr, Node body, Node nextCase) {
        super(line, expr.containsVariableAssignment());
        this.expression = expr;
        this.body = body;
        this.nextCase = nextCase;
    }

    public Node getExpression() {
        return this.expression;
    }

    public Node getBody() {
        return this.body;
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public boolean isSinglePattern() {
        return this.getNextCase() == null;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitInNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return InNode.createList(this.expression, this.body, this.nextCase);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.INNODE;
    }
}

