/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends AbstractRubyMethod {
    protected RubyUnboundMethod(Ruby runtime2) {
        super(runtime2, runtime2.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, CacheEntry entry) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.entry = entry;
        newMethod.method = entry.method;
        newMethod.sourceModule = entry.sourceModule;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime2) {
        RubyClass newClass = runtime2.defineClass("UnboundMethod", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        newClass.setClassIndex(ClassIndex.UNBOUNDMETHOD);
        newClass.setReifiedClass(RubyUnboundMethod.class);
        newClass.defineAnnotatedMethods(AbstractRubyMethod.class);
        newClass.defineAnnotatedMethods(RubyUnboundMethod.class);
        newClass.getSingletonClass().undefineMethod("new");
        return newClass;
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context, this.equals(other));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AbstractRubyMethod)) {
            return false;
        }
        if (this.method instanceof ProcMethod) {
            return ((ProcMethod)this.method).isSame(((AbstractRubyMethod)other).getMethod());
        }
        AbstractRubyMethod otherMethod = (AbstractRubyMethod)other;
        return this.originModule == otherMethod.originModule && this.method.getRealMethod().getSerialNumber() == otherMethod.method.getRealMethod().getSerialNumber();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        long serial = this.method.getRealMethod().getSerialNumber();
        return 997 * ((int)(serial >> 32) ^ (int)serial & 0xFF);
    }

    @JRubyMethod
    public RubyMethod bind(ThreadContext context, IRubyObject aReceiver) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        receiverClass.checkValidBindTargetFrom(context, (RubyModule)this.owner(context), true);
        CacheEntry methodEntry = this.convertUnboundMethodToCallableEntry(context, receiverClass);
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, methodEntry, aReceiver);
    }

    private CacheEntry convertUnboundMethodToCallableEntry(ThreadContext context, RubyClass receiverClass) {
        CacheEntry methodEntry = this.entry;
        if (this.implementationModule.isModule()) {
            IncludedModuleWrapper alreadyIncluded = receiverClass.findModuleInAncestors(this.implementationModule);
            if (alreadyIncluded != null) {
                methodEntry = new CacheEntry(this.method, alreadyIncluded, this.entry.token);
            } else {
                IncludedModuleWrapper boundModule = new IncludedModuleWrapper(context.runtime, receiverClass, this.implementationModule);
                methodEntry = new CacheEntry(this.method, boundModule, this.entry.token);
            }
        }
        return methodEntry;
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyUnboundMethod rbClone() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry);
        if (this.isFrozen()) {
            unboundMethod.setFrozen(true);
        }
        return unboundMethod;
    }

    @JRubyMethod(required=1, rest=true, checkArity=false, keywords=true)
    public IRubyObject bind_call(ThreadContext context, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        IRubyObject receiver2 = args2[0];
        IRubyObject[] newArgs = new IRubyObject[argc - 1];
        System.arraycopy(args2, 1, newArgs, 0, argc - 1);
        RubyClass receiverClass = receiver2.getMetaClass();
        receiverClass.checkValidBindTargetFrom(context, (RubyModule)this.owner(context), true);
        CacheEntry methodEntry = this.convertUnboundMethodToCallableEntry(context, receiverClass);
        return this.method.call(context, receiver2, methodEntry.sourceModule, this.methodName, newArgs, block);
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        StringBuilder str = new StringBuilder(24).append("#<");
        char sharp = '#';
        str.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            str.append(this.implementationModule.inspect().toString());
        } else {
            str.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                str.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        str.append(sharp).append(this.methodName);
        String realName = this.method.getRealMethod().getName();
        if (realName != null && !this.methodName.equals(realName)) {
            str.append('(').append(realName).append(')');
        }
        str.append('(').append(')');
        String filename2 = this.getFilename();
        if (filename2 != null) {
            str.append(' ').append(this.getFilename()).append(':').append(this.getLine());
        }
        str.append('>');
        RubyString res = RubyString.newString(this.getRuntime(), str);
        return res;
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        RubyClass superClass = null;
        if (this.method instanceof PartialDelegatingMethod || this.method instanceof AliasMethod) {
            RubyModule definedClass = this.method.getRealMethod().getDefinedClass();
            RubyModule module = this.sourceModule.findImplementer(definedClass);
            if (module != null) {
                superClass = module.getSuperClass();
            }
        } else {
            superClass = this.sourceModule.getSuperClass();
        }
        return this.super_method(context, null, superClass);
    }
}

