/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.specialized;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.JDKVersion;
import me.qmx.jitescript.JiteClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.NonBlockingHashMapLong;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.LabelNode;

public class RubyObjectSpecializer {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String GENERATED_PACKAGE = "org/jruby/gen/";
    private final Ruby runtime;
    private final NonBlockingHashMapLong<ClassAndAllocator> specializedClasses = new NonBlockingHashMapLong();

    private ClassAndAllocator getClassForSize(int size2) {
        return this.specializedClasses.get(size2);
    }

    public RubyObjectSpecializer(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public ObjectAllocator specializeForVariables(RubyClass klass, Set<String> foundVariables) {
        ClassAndAllocator cna;
        int size2 = Math.min(foundVariables.size(), (Integer)Options.REIFY_VARIABLES_MAX.load());
        if (((Boolean)Options.REIFY_VARIABLES_NAME.load()).booleanValue()) {
            cna = this.generateSpecializedRubyObject(RubyObjectSpecializer.uniqueClassName(klass), size2, false);
        } else {
            cna = this.getClassForSize(size2);
            if (cna == null) {
                cna = this.generateSpecializedRubyObject(RubyObjectSpecializer.genericClassName(size2), size2, true);
            }
        }
        try {
            int offset2 = 0;
            for (String name2 : foundVariables) {
                klass.getVariableTableManager().getVariableAccessorForRubyVar(name2, LOOKUP.findGetter(cna.cls, "var" + offset2, Object.class), LOOKUP.findSetter(cna.cls, "var" + offset2, Object.class));
                if (++offset2 < size2) continue;
                break;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        klass.setReifiedClass(cna.cls);
        klass.setAllocator(cna.allocator);
        return cna.allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassAndAllocator generateSpecializedRubyObject(String className, int size2, boolean cache) {
        ClassAndAllocator cna;
        RubyObjectSpecializer rubyObjectSpecializer = this;
        synchronized (rubyObjectSpecializer) {
            Class<?> specialized;
            try {
                specialized = this.runtime.getJRubyClassLoader().loadClass(className.replace('/', '.'));
            }
            catch (ClassNotFoundException cnfe) {
                specialized = this.generateInternal(className, size2);
            }
            try {
                ObjectAllocator allocator = (ObjectAllocator)specialized.getDeclaredClasses()[0].getConstructor(new Class[0]).newInstance(new Object[0]);
                cna = new ClassAndAllocator(specialized, allocator);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (cache) {
            this.specializedClasses.put(size2, cna);
        }
        return cna;
    }

    private static String genericClassName(int size2) {
        return "org/jruby/gen/RubyObject" + size2;
    }

    private static String uniqueClassName(RubyClass klass) {
        String className = klass.getName();
        className = className.startsWith("#") ? "Anonymous" + Integer.toHexString(System.identityHashCode(klass)) : className.replace("::", "/");
        return GENERATED_PACKAGE + className;
    }

    public static void main(String[] args2) throws Throwable {
        String targetPath = args2[0];
        Files.createDirectories(Paths.get(targetPath, GENERATED_PACKAGE), new FileAttribute[0]);
        int maxVars = (Integer)Options.REIFY_VARIABLES_MAX.load();
        for (int i2 = 0; i2 <= maxVars; ++i2) {
            String clsPath = RubyObjectSpecializer.genericClassName(i2);
            JiteClass jcls = RubyObjectSpecializer.generateJiteClass(clsPath, i2);
            Files.write(Paths.get(targetPath, clsPath + ".class"), jcls.toBytes(JDKVersion.V1_8), new OpenOption[0]);
            Files.write(Paths.get(targetPath, clsPath + "Allocator.class"), ((JiteClass)jcls.getChildClasses().get(0)).toBytes(JDKVersion.V1_8), new OpenOption[0]);
        }
    }

    private Class generateInternal(String clsPath, int size2) {
        JiteClass jiteClass = RubyObjectSpecializer.generateJiteClass(clsPath, size2);
        Class specializedClass = this.defineClass(jiteClass);
        this.defineClass((JiteClass)jiteClass.getChildClasses().get(0));
        return specializedClass;
    }

    private static JiteClass generateJiteClass(final String clsPath, final int size2) {
        final String baseName = CodegenUtils.p(RubyObject.class);
        JiteClass jiteClass = new JiteClass(clsPath, baseName, new String[0]){
            {
                super(x0, x1, x2);
                int i2 = 0;
                while (i2 < size2) {
                    int offset2 = i2++;
                    this.defineField("var" + offset2, 1, CodegenUtils.ci(Object.class), null);
                }
                this.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), new CodeBlock(){
                    {
                        this.aload(0);
                        this.aload(1);
                        this.aload(2);
                        this.invokespecial(baseName, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
                        this.voidreturn();
                    }
                });
                this.defineMethod("getVariable", 1, CodegenUtils.sig(Object.class, Integer.TYPE), new CodeBlock(){
                    {
                        LabelNode parentCall = new LabelNode(new Label());
                        this.line(0);
                        if (size2 > 0) {
                            RubyObjectSpecializer.genGetSwitch(clsPath, size2, this, 1);
                        }
                        this.line(1);
                        this.aload(0);
                        this.iload(1);
                        this.invokespecial(CodegenUtils.p(RubyObject.class), "getVariable", CodegenUtils.sig(Object.class, Integer.TYPE));
                        this.areturn();
                    }
                });
                this.defineMethod("setVariable", 1, CodegenUtils.sig(Void.TYPE, Integer.TYPE, Object.class), new CodeBlock(){
                    {
                        LabelNode parentCall = new LabelNode(new Label());
                        this.line(2);
                        if (size2 > 0) {
                            RubyObjectSpecializer.genPutSwitch(clsPath, size2, this, 1);
                        }
                        this.line(3);
                        this.aload(0);
                        this.iload(1);
                        this.aload(2);
                        this.invokespecial(CodegenUtils.p(RubyObject.class), "setVariable", CodegenUtils.sig(Void.TYPE, Integer.TYPE, Object.class));
                        this.voidreturn();
                    }
                });
                this.addChildClass(new JiteClass(clsPath + "Allocator", CodegenUtils.p(Object.class), Helpers.arrayOf(CodegenUtils.p(ObjectAllocator.class))){
                    {
                        super(x0, x1, x2);
                        this.defineDefaultConstructor();
                        this.defineMethod("allocate", 1, CodegenUtils.sig(IRubyObject.class, Ruby.class, RubyClass.class), new CodeBlock(){
                            {
                                this.newobj(clsPath);
                                this.dup();
                                this.aload(1);
                                this.aload(2);
                                this.invokespecial(clsPath, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
                                this.areturn();
                            }
                        });
                    }
                });
            }
        };
        return jiteClass;
    }

    private static void genGetSwitch(String clsPath, int size2, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.getfield(clsPath, "var" + i2, CodegenUtils.ci(Object.class));
            block.areturn();
        }
        block.label(defaultError);
    }

    private static void genPutSwitch(String clsPath, int size2, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.aload(2);
            block.putfield(clsPath, "var" + i2, CodegenUtils.ci(Object.class));
            block.voidreturn();
        }
        block.label(defaultError);
    }

    private Class defineClass(JiteClass jiteClass) {
        return this.runtime.getJRubyClassLoader().defineClass(RubyObjectSpecializer.classNameFromJiteClass(jiteClass), jiteClass.toBytes(JDKVersion.V1_8));
    }

    private static String classNameFromJiteClass(JiteClass jiteClass) {
        return jiteClass.getClassName().replace('/', '.');
    }

    static class ClassAndAllocator {
        final Class cls;
        final ObjectAllocator allocator;

        ClassAndAllocator(Class cls, ObjectAllocator allocator) {
            this.cls = cls;
            this.allocator = allocator;
        }
    }
}

