/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import jnr.posix.JavaSecuredFile;
import org.jruby.Ruby;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.EmptyFileResource;
import org.jruby.util.FileResource;
import org.jruby.util.JarResource;
import org.jruby.util.NullDeviceResource;
import org.jruby.util.RegularFileResource;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.URLResource;

public class JRubyFile
extends JavaSecuredFile {
    private static final long serialVersionUID = 435364547567567L;
    private static final Pattern windowsComPattern = Pattern.compile("(?:\\/\\/\\.\\/|\\\\\\\\\\.\\\\)?COM\\d\\d?", 2);
    public static final JRubyFile DUMMY = new JRubyFile(""){

        @Override
        public String getAbsolutePath() {
            return "";
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean exists() {
            return false;
        }

        @Override
        public String getCanonicalPath() throws IOException {
            throw new FileNotFoundException("File does not exist");
        }

        @Override
        public String getPath() {
            return "";
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public File getAbsoluteFile() {
            return this;
        }

        @Override
        public File getCanonicalFile() throws IOException {
            throw new FileNotFoundException("File does not exist");
        }

        @Override
        public String getParent() {
            return "";
        }

        @Override
        public File getParentFile() {
            return this;
        }

        @Override
        public String[] list(FilenameFilter filter) {
            return new String[0];
        }

        @Override
        public File[] listFiles() {
            return new File[0];
        }

        @Override
        public File[] listFiles(FileFilter filter) {
            return new File[0];
        }

        @Override
        public File[] listFiles(FilenameFilter filter) {
            return new File[0];
        }
    };

    public static JRubyFile create(String cwd, String pathname2) {
        if (pathname2 == null || pathname2.length() == 0 || Ruby.isSecurityRestricted()) {
            return DUMMY;
        }
        if (pathname2.startsWith("file:")) {
            pathname2 = pathname2.substring(5);
        }
        return JRubyFile.createNoUnicodeConversion(cwd, pathname2, new File(pathname2));
    }

    public static FileResource createResource(ThreadContext context, String pathname2) {
        return JRubyFile.createResource(context.runtime, pathname2);
    }

    public static FileResource createResourceAsFile(Ruby runtime2, String pathname2) {
        return JRubyFile.createResource(runtime2, runtime2.getCurrentDirectory(), pathname2, true);
    }

    public static FileResource createRestrictedResource(String cwd, String pathname2) {
        return JRubyFile.createResource(null, cwd, pathname2);
    }

    public static FileResource createResource(Ruby runtime2, String pathname2) {
        return JRubyFile.createResource(runtime2, runtime2.getCurrentDirectory(), pathname2, false);
    }

    public static FileResource createResource(Ruby runtime2, String cwd, String pathname2) {
        return JRubyFile.createResource(runtime2, cwd, pathname2, false);
    }

    private static FileResource createResource(Ruby runtime2, String cwd, String pathname2, boolean isFile) {
        FileResource resource2 = EmptyFileResource.create(pathname2);
        if (resource2 != null) {
            return resource2;
        }
        resource2 = JarResource.create(pathname2);
        if (resource2 != null) {
            return resource2;
        }
        if (Platform.IS_WINDOWS && (pathname2.equalsIgnoreCase("nul") || pathname2.equalsIgnoreCase("nul:"))) {
            return new NullDeviceResource();
        }
        if (pathname2.indexOf(58) > 0) {
            if (pathname2.startsWith("classpath:")) {
                pathname2 = "uri:classloader:/" + pathname2.substring(10);
            }
            if (pathname2.startsWith("uri:")) {
                return URLResource.create(runtime2, pathname2, isFile);
            }
            if (pathname2.startsWith("file:") && (pathname2 = pathname2.substring(5)).length() == 0) {
                return EmptyFileResource.INSTANCE;
            }
        }
        if (cwd != null && (cwd.startsWith("uri:") || cwd.startsWith("file:")) && !new File(pathname2).isAbsolute()) {
            return JRubyFile.createResource(runtime2, null, cwd + '/' + pathname2);
        }
        return new RegularFileResource(runtime2 != null ? runtime2.getPosix() : null, JRubyFile.create(cwd, pathname2), pathname2);
    }

    public static String normalizeSeps(String path2) {
        return Platform.IS_WINDOWS ? path2.replace(File.separatorChar, '/') : path2;
    }

    private static JRubyFile createNoUnicodeConversion(String cwd, String pathname2, File path2) {
        if (path2.isAbsolute()) {
            return new JRubyFile(path2);
        }
        if (Platform.IS_WINDOWS) {
            if (JRubyFile.isComPort(pathname2)) {
                return new JRubyFile(pathname2);
            }
            if (pathname2.startsWith("/") || pathname2.startsWith("\\")) {
                return new JRubyFile(path2);
            }
        }
        if (cwd != null && cwd.startsWith("uri:") && !pathname2.startsWith("uri:") && !pathname2.contains("!/")) {
            return new JRubyFile(cwd + '/' + pathname2);
        }
        path2 = new File(cwd, pathname2);
        if (!path2.isAbsolute()) {
            throw new IllegalArgumentException("Neither current working directory (" + cwd + ") nor pathname (" + pathname2 + ") led to an absolute path");
        }
        return new JRubyFile(path2);
    }

    public static String getFileProperty(String property) {
        return JRubyFile.normalizeSeps(SafePropertyAccessor.getProperty(property, "/"));
    }

    static boolean isComPort(String path2) {
        if (!Platform.IS_WINDOWS) {
            return false;
        }
        int len = path2.length();
        return len < 10 && len > 3 && len != 5 && windowsComPattern.matcher(path2).matches();
    }

    private JRubyFile(File file2) {
        this(file2.getAbsolutePath());
    }

    public JRubyFile(String filename2) {
        super(filename2);
    }

    public JRubyFile(String parent, String child) {
        super(parent, child);
    }

    public String getAbsolutePath() {
        String path2 = super.getPath();
        if (path2.startsWith("uri:")) {
            return JRubyFile.normalizeSeps(path2.replaceFirst(":/([^/])", "://$1"));
        }
        return JRubyFile.normalizeSeps(new File(path2).getAbsolutePath());
    }

    public String getCanonicalPath() throws IOException {
        try {
            return JRubyFile.normalizeSeps(super.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IOException("Unable to canonicalize path: " + this.getAbsolutePath(), e);
        }
    }

    public String getPath() {
        return JRubyFile.normalizeSeps(super.getPath());
    }

    final String getPathDefault() {
        return super.getPath();
    }

    public String toString() {
        return JRubyFile.normalizeSeps(super.toString());
    }

    public File getAbsoluteFile() {
        return new JRubyFile(this.getAbsolutePath());
    }

    public File getCanonicalFile() throws IOException {
        return new JRubyFile(this.getCanonicalPath());
    }

    public String getParent() {
        String parent = super.getParent();
        if (parent != null) {
            parent = JRubyFile.normalizeSeps(parent);
        }
        return parent;
    }

    public File getParentFile() {
        String parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return new JRubyFile(parent);
    }

    public static File[] listRoots() {
        File[] roots = File.listRoots();
        JRubyFile[] smartRoots = new JRubyFile[roots.length];
        int j = roots.length;
        for (int i2 = 0; i2 < j; ++i2) {
            smartRoots[i2] = new JRubyFile(roots[i2].getPath());
        }
        return smartRoots;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        return new JRubyFile(File.createTempFile(prefix, suffix, directory));
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return new JRubyFile(File.createTempFile(prefix, suffix));
    }

    public String[] list(FilenameFilter filter) {
        String[] files = super.list(filter);
        if (files == null) {
            return null;
        }
        String[] smartFiles = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = JRubyFile.normalizeSeps(files[i2]);
        }
        return smartFiles;
    }

    public File[] listFiles() {
        return this.convertFiles(super.listFiles());
    }

    public File[] listFiles(FileFilter filter) {
        return this.convertFiles(super.listFiles(filter));
    }

    public File[] listFiles(FilenameFilter filter) {
        return this.convertFiles(super.listFiles(filter));
    }

    private JRubyFile[] convertFiles(File[] files) {
        if (files == null) {
            return null;
        }
        String absolutePath = super.getAbsolutePath();
        JRubyFile[] smartFiles = new JRubyFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file2 = files[i2];
            smartFiles[i2] = JRubyFile.createNoUnicodeConversion(absolutePath, file2.getPath(), file2);
        }
        return smartFiles;
    }
}

