/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.api.Convert;
import org.jruby.platform.Platform;
import org.jruby.runtime.Helpers;
import org.jruby.util.ByteList;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;

public class Dir {
    public static final boolean DOSISH = Platform.IS_WINDOWS;
    public static final boolean CASEFOLD_FILESYSTEM = DOSISH || Platform.IS_MAC;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_GLOB_SKIPDOT = 128;
    public static final int FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY = ByteList.NULL_ARRAY;
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] STAR = new byte[]{42};
    public static final byte[] DOUBLE_STAR = new byte[]{42, 42};
    private static final GlobFunc<List<ByteList>> push_pattern = (ptr, p2, len, enc, ary) -> {
        ary.add(new ByteList(ptr, p2, len, enc, true));
        return 0;
    };
    private static final GlobFunc<GlobArgs> glob_caller = (ptr, p2, len, enc, args2) -> {
        args2.c = p2;
        return args2.func.call(ptr, args2.c, len, enc, args2.arg);
    };

    private static boolean isdirsep(int c) {
        return c == 47 || DOSISH && c == 92;
    }

    private static boolean isdirsep(byte c) {
        return Dir.isdirsep(c & 0xFF);
    }

    public static int fnmatch(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags2) {
        return Dir.fnmatch(bytes2, pstart, pend, string2, sstart, send2, flags2, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int fnmatch(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags2, Encoding enc) {
        boolean period = (flags2 & 4) == 0;
        boolean pathname2 = (flags2 & 2) != 0;
        int pat_pos = pstart;
        int str_pos = sstart;
        int ptmp = -1;
        int stmp = -1;
        if (pathname2) {
            while (true) {
                FilenameMatch fnmatch2;
                if (Dir.isDoubleStarAndSlash(bytes2, pat_pos)) {
                    while (Dir.isDoubleStarAndSlash(bytes2, pat_pos += 3)) {
                    }
                    ptmp = pat_pos;
                    stmp = str_pos;
                }
                if ((fnmatch2 = new FilenameMatch(pat_pos, str_pos, flags2)).helper(bytes2, pend, string2, send2, enc) == 0) {
                    pat_pos = fnmatch2.pcur;
                    for (str_pos = fnmatch2.scur; str_pos < send2 && string2[str_pos] != 47; ++str_pos) {
                    }
                    if (pat_pos < pend && str_pos < send2) {
                        ++pat_pos;
                        ++str_pos;
                        continue;
                    }
                    if (pat_pos == pend && str_pos == send2) {
                        return 0;
                    }
                }
                if (ptmp == -1 || stmp == -1 || period && string2[stmp] == 46 || (stmp = Dir.nextSlashIndex(string2, stmp, send2)) >= send2) break;
                pat_pos = ptmp;
                str_pos = ++stmp;
            }
            return 1;
        }
        FilenameMatch fnmatch3 = new FilenameMatch(pstart, sstart, flags2);
        return fnmatch3.helper(bytes2, pend, string2, send2, enc);
    }

    private static boolean isDoubleStarAndSlash(byte[] bytes2, int pos2) {
        if (bytes2.length - pos2 <= 2) {
            return false;
        }
        return bytes2[pos2] == 42 && bytes2[pos2 + 1] == 42 && bytes2[pos2 + 2] == 47;
    }

    private static int nextSlashIndex(byte[] bytes2, int start2, int end2) {
        int idx;
        for (idx = start2; idx < end2 && idx < bytes2.length && bytes2[idx] != 47; ++idx) {
        }
        return idx;
    }

    public static List<ByteList> push_glob(Ruby runtime2, String cwd, ByteList globByteList, int flags2, boolean sort2) {
        if (!globByteList.isEmpty()) {
            ArrayList<ByteList> result2 = new ArrayList<ByteList>();
            Dir.push_braces(runtime2, cwd, result2, new GlobPattern(globByteList, flags2), sort2);
            return result2;
        }
        return Collections.emptyList();
    }

    private static int push_braces(Ruby runtime2, String cwd, List<ByteList> result2, GlobPattern pattern, boolean sort2) {
        pattern.reset();
        int lbrace = pattern.indexOf((byte)123);
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1 || lbrace > 0 && pattern.bytes[lbrace - 1] == 92 && (lbrace <= 1 || pattern.bytes[lbrace - 2] != 92) || rbrace > 0 && pattern.bytes[rbrace - 1] == 92 && (rbrace <= 1 || pattern.bytes[rbrace - 2] != 92)) {
            ByteList unescaped = new ByteList(pattern.bytes.length - 1);
            unescaped.setEncoding(pattern.enc);
            for (int i2 = pattern.begin; i2 < pattern.end; ++i2) {
                byte b2 = pattern.bytes[i2];
                if (b2 == 92 && i2 < pattern.bytes.length - 1) {
                    byte next_b = pattern.bytes[i2 + 1];
                    if (next_b == 123 || next_b == 125) continue;
                    unescaped.append(b2);
                    continue;
                }
                unescaped.append(b2);
            }
            return Dir.push_globs(runtime2, cwd, result2, unescaped, pattern.flags, sort2);
        }
        ByteList bytes2 = new ByteList(20);
        bytes2.setEncoding(pattern.enc);
        int i3 = lbrace;
        while (pattern.bytes[i3] != 125) {
            int middleRegionIndex;
            for (i3 = middleRegionIndex = i3 + 1; i3 < pattern.end && pattern.bytes[i3] != 125; ++i3) {
                if (pattern.bytes[i3] == 44) {
                    if (i3 <= pattern.begin || pattern.bytes[i3 - 1] != 92) break;
                    continue;
                }
                if (pattern.bytes[i3] != 123) continue;
                i3 = pattern.findClosingIndexOf(i3);
            }
            bytes2.length(0);
            bytes2.append(pattern.bytes, pattern.begin, lbrace - pattern.begin);
            bytes2.append(pattern.bytes, middleRegionIndex, i3 - middleRegionIndex);
            bytes2.append(pattern.bytes, rbrace + 1, pattern.end - (rbrace + 1));
            int status2 = Dir.push_braces(runtime2, cwd, result2, new GlobPattern(bytes2, pattern.flags), sort2);
            if (status2 == 0) continue;
            return status2;
        }
        return 0;
    }

    private static int push_globs(Ruby runtime2, String cwd, List<ByteList> ary, ByteList pattern, int flags2, boolean sort2) {
        ArrayList<ByteList> tmpAry = new ArrayList<ByteList>();
        int globRet = Dir.glob_helper(runtime2, cwd, pattern, flags2 |= FNM_SYSCASE, new GlobArgs(push_pattern, tmpAry));
        if (sort2) {
            Collections.sort(tmpAry);
        }
        ary.addAll(tmpAry);
        return globRet;
    }

    public static ArrayList<String> braces(String pattern, int flags2, ArrayList<String> patterns) {
        boolean escape = (flags2 & 1) == 0;
        int rbrace = -1;
        int lbrace = -1;
        int i2 = pattern.indexOf(123);
        if (i2 >= 0) {
            int nest = 0;
            while (i2 < pattern.length()) {
                char c = pattern.charAt(i2);
                if (c == '{') {
                    if (nest == 0) {
                        lbrace = i2;
                    }
                    ++nest;
                }
                if (c == '}') {
                    --nest;
                }
                if (nest == 0) {
                    rbrace = i2;
                    break;
                }
                if (c == '\\' && escape) {
                    ++i2;
                }
                ++i2;
            }
        }
        if (lbrace >= 0 && rbrace >= 0) {
            int pos2 = lbrace;
            String front = pattern.substring(0, lbrace);
            String back = pattern.substring(rbrace + 1);
            while (pos2 < rbrace) {
                int nest = 0;
                int last2 = ++pos2;
                while (pos2 < rbrace && (pattern.charAt(pos2) != ',' || nest != 0)) {
                    if (pattern.charAt(pos2) == '{') {
                        ++nest;
                    }
                    if (pattern.charAt(pos2) == '}') {
                        --nest;
                    }
                    if (pattern.charAt(pos2) == '\\' && escape && ++pos2 == rbrace) break;
                    ++pos2;
                }
                String brace_pattern = front + pattern.substring(last2, pos2) + back;
                patterns.add(brace_pattern);
                Dir.braces(brace_pattern, flags2, patterns);
            }
        }
        return patterns;
    }

    private static GlobMagic has_magic(byte[] bytes2, int begin2, int end2, int flags2) {
        boolean escape = (flags2 & 1) == 0;
        int open2 = 0;
        boolean hasalpha = false;
        block6: for (int i2 = begin2; i2 < end2; ++i2) {
            switch (bytes2[i2]) {
                case 42: 
                case 63: {
                    return GlobMagic.MAGICAL;
                }
                case 91: {
                    ++open2;
                    continue block6;
                }
                case 93: {
                    if (open2 <= 0) continue block6;
                    return GlobMagic.MAGICAL;
                }
                case 92: {
                    if (!escape) continue block6;
                    return GlobMagic.MAGICAL;
                }
                default: {
                    if (!Platform.IS_WINDOWS && !Dir.isAlpha(bytes2[i2])) continue block6;
                    hasalpha = true;
                }
            }
        }
        return hasalpha ? GlobMagic.ALPHA : GlobMagic.PLAIN;
    }

    private static boolean isAlpha(byte b2) {
        return Character.isLetter(Byte.toUnsignedInt(b2));
    }

    private static int remove_backslashes(byte[] bytes2, int index2, int end2) {
        int i2 = index2;
        while (index2 < end2 && (bytes2[index2] != 92 || ++index2 != end2)) {
            bytes2[i2] = bytes2[index2];
            ++index2;
            ++i2;
        }
        return i2;
    }

    private static int indexOf(byte[] bytes2, int begin2, int end2, byte ch) {
        for (int i2 = begin2; i2 < end2; ++i2) {
            if (bytes2[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] bytes2, int begin2, int end2) {
        int len = end2 - begin2;
        if (!(len <= 1 || bytes2[end2 - 1] != 47 || DOSISH && bytes2[end2 - 2] == 58)) {
            --len;
        }
        byte[] alloc2 = new byte[len];
        System.arraycopy(bytes2, begin2, alloc2, 0, len);
        return alloc2;
    }

    private static byte[] extractScheme(byte[] path2, int begin2, int end2) {
        int colon = Dir.findScheme(path2, begin2, end2);
        if (colon == -1) {
            return null;
        }
        while (++colon < end2 && path2[colon] == 47) {
        }
        byte[] scheme = new byte[--colon - begin2];
        System.arraycopy(path2, begin2, scheme, 0, colon - begin2);
        return scheme;
    }

    private static ByteList prepend(ByteList buf, byte[] prefix) {
        ByteList newbuf = new ByteList(prefix);
        newbuf.setEncoding(buf.getEncoding());
        newbuf.append(buf);
        return newbuf;
    }

    private static byte[] prependScheme(byte[] scheme, byte[] path2, int begin2, int end2) {
        byte[] newpath = new byte[scheme.length + (end2 - begin2)];
        System.arraycopy(scheme, 0, newpath, 0, scheme.length);
        System.arraycopy(path2, begin2, newpath, scheme.length, end2 - begin2);
        return newpath;
    }

    private static boolean beginsWithDriveLetter(byte[] path2, int begin2, int end2) {
        return DOSISH && begin2 + 2 < end2 && path2[begin2 + 1] == 58 && Dir.isdirsep(path2[begin2 + 2]);
    }

    private static int findScheme(byte[] path2, int begin2, int end2) {
        String schemeStr = new String(path2, begin2, Math.min(16, end2 - begin2));
        if (schemeStr.startsWith("uri:classloader:")) {
            return 16;
        }
        if (schemeStr.startsWith("uri:")) {
            return 4;
        }
        if (schemeStr.startsWith("file:")) {
            return 5;
        }
        if (schemeStr.startsWith("classpath:")) {
            return 10;
        }
        if (schemeStr.startsWith("jar:file:")) {
            return Helpers.memchr(path2, begin2, 33, end2 - begin2) + 1;
        }
        return -1;
    }

    private static boolean isRoot(byte[] base) {
        int length2 = base.length;
        return length2 == 0 || length2 == 1 && Dir.isdirsep(base[0]) || length2 == 3 && Dir.beginsWithDriveLetter(base, 0, length2);
    }

    private static boolean isAbsolutePath(byte[] path2, int begin2, int length2) {
        return Dir.isdirsep(path2[begin2]) || Dir.beginsWithDriveLetter(path2, begin2, length2);
    }

    private static String[] files(FileResource directory) {
        String[] files = directory.list();
        return files == null ? StringSupport.EMPTY_STRING_ARRAY : files;
    }

    private static int addToResultIfExists(Ruby runtime2, String cwd, byte[] bytes2, int begin2, int end2, Encoding enc, GlobFunc<GlobArgs> func, GlobArgs arg2) {
        String fileName = new String(bytes2, begin2, end2 - begin2, enc.getCharset());
        if (Platform.IS_WINDOWS && cwd == null && !fileName.isEmpty() && fileName.charAt(0) == '/') {
            cwd = System.getenv("SYSTEMDRIVE");
            if (cwd == null) {
                cwd = "C:";
            }
            cwd = (String)cwd + "/";
        }
        return JRubyFile.createResource(runtime2, (String)cwd, fileName).exists() ? func.call(bytes2, begin2, end2 - begin2, enc, arg2) : 0;
    }

    private static int glob_helper(Ruby runtime2, String cwd, ByteList path2, int flags2, GlobArgs arg2) {
        int begin2 = path2.getBegin();
        int end2 = begin2 + path2.length();
        byte[] bytes2 = path2.getUnsafeBytes();
        byte[] scheme = Dir.extractScheme(bytes2, begin2, end2);
        if (scheme != null) {
            path2.delete(begin2, scheme.length);
        }
        return Dir.glob_helper(runtime2, cwd, scheme, path2, -1, flags2, glob_caller, arg2);
    }

    private static int glob_helper(Ruby runtime2, String cwd, byte[] scheme, ByteList b2, int sub3, int flags2, GlobFunc<GlobArgs> func, GlobArgs arg2) {
        GlobMagic nonMagic;
        byte[] path2 = b2.getUnsafeBytes();
        int begin2 = b2.getBegin();
        int end2 = begin2 + b2.length();
        Encoding enc = b2.getEncoding();
        int ptr = sub3 != -1 ? sub3 : begin2;
        GlobMagic globMagic = nonMagic = CASEFOLD_FILESYSTEM ? GlobMagic.PLAIN : GlobMagic.ALPHA;
        if (Dir.has_magic(path2, ptr, end2, flags2).compareTo(nonMagic) <= 0) {
            if (DOSISH || (flags2 & 1) == 0) {
                end2 = Dir.remove_backslashes(path2, ptr, end2);
            }
            if (end2 <= begin2) {
                return 0;
            }
            if (scheme != null) {
                path2 = Dir.prependScheme(scheme, path2, begin2, end2);
                begin2 = 0;
                end2 = path2.length;
            }
            String pwd = Dir.isAbsolutePath(path2, begin2, end2) ? null : cwd;
            return Dir.addToResultIfExists(runtime2, pwd, path2, begin2, end2, enc, func, arg2);
        }
        ArrayList<ByteList> links = new ArrayList<ByteList>();
        int status2 = 0;
        block0: while (ptr != -1 && status2 == 0) {
            int slashIndex;
            block23: {
                block25: {
                    boolean skipdot;
                    FileResource resource;
                    boolean recursive;
                    byte[] magic;
                    byte[] base;
                    GlobMagic magical;
                    block24: {
                        int nextEndIndex;
                        int nextStartIndex;
                        byte[] dir;
                        int segmentEnd;
                        if (path2[ptr] == 47) {
                            ++ptr;
                        }
                        if ((magical = Dir.has_magic(path2, ptr, segmentEnd = (slashIndex = Dir.indexOf(path2, ptr, end2, (byte)47)) == -1 ? end2 : slashIndex, flags2)).compareTo(nonMagic) <= 0) break block23;
                        base = Dir.extract_path(path2, begin2, ptr);
                        if (begin2 == ptr) {
                            byte[] byArray = new byte[1];
                            v2 = byArray;
                            byArray[0] = 46;
                        } else {
                            v2 = dir = base;
                        }
                        if (scheme != null) {
                            dir = Dir.prependScheme(scheme, dir, 0, dir.length);
                        }
                        magic = Dir.extract_path(path2, ptr, segmentEnd);
                        recursive = false;
                        resource = JRubyFile.createResource(runtime2, cwd, new String(dir, enc.getCharset()));
                        if (!resource.isDirectory()) break;
                        if (slashIndex == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block24;
                        recursive = true;
                        ByteList buf = Dir.createPath(base, null, enc);
                        int indexOfSlash = slashIndex;
                        while (Arrays.equals(magic = Dir.extract_path(path2, nextStartIndex, nextEndIndex = (indexOfSlash = Dir.indexOf(path2, nextStartIndex = indexOfSlash + 1, end2, (byte)47)) == -1 ? end2 : indexOfSlash), DOUBLE_STAR) && indexOfSlash != -1) {
                        }
                        int remainingPathStartIndex = Arrays.equals(magic, DOUBLE_STAR) ? nextStartIndex : nextStartIndex - 1;
                        remainingPathStartIndex = base.length > 0 ? remainingPathStartIndex : remainingPathStartIndex + 1;
                        buf.append(path2, remainingPathStartIndex, end2 - remainingPathStartIndex);
                        if ((flags2 & 4) == 0) {
                            flags2 |= 0x80;
                        }
                        if ((status2 = Dir.glob_helper(runtime2, cwd, scheme, buf, base.length, flags2, func, arg2)) != 0) break block25;
                    }
                    boolean bl = skipdot = (flags2 & 0x80) != 0;
                    if (recursive || magical.compareTo(GlobMagic.MAGICAL) >= 0) {
                        flags2 |= 0x80;
                    }
                    for (String file2 : Dir.files(resource)) {
                        boolean dirMatch;
                        if (Dir.isIgnorableDotOrDotDot(file2, recursive, flags2, skipdot)) continue;
                        byte[] fileBytes = Dir.getBytesInUTF8(file2);
                        ByteList buf = Dir.createPath(base, fileBytes, enc);
                        if (recursive) {
                            ByteList resBuf;
                            FileResource r;
                            if (Dir.fnmatch(STAR, 0, 1, fileBytes, 0, fileBytes.length, flags2) != 0 || (r = JRubyFile.createResource(runtime2, cwd, Convert.asJavaString(resBuf = scheme != null ? Dir.prepend(buf, scheme) : buf))).isSymLink() || !r.isDirectory() || ".".equals(file2) || "..".equals(file2)) continue;
                            int len = buf.getRealSize();
                            buf.append(SLASH);
                            buf.append(DOUBLE_STAR);
                            buf.append(path2, slashIndex, end2 - slashIndex);
                            status2 = Dir.glob_helper(runtime2, cwd, scheme, buf, buf.getBegin() + len, flags2, func, arg2);
                            if (status2 == 0) continue;
                            break;
                        }
                        if (Dir.fnmatch(magic, 0, magic.length, fileBytes, 0, fileBytes.length, flags2) != 0) continue;
                        boolean bl2 = dirMatch = slashIndex == end2 - 1 && JRubyFile.createResource(runtime2, cwd, Convert.asJavaString(buf)).isDirectory();
                        if (slashIndex == -1 || dirMatch) {
                            if (scheme != null) {
                                buf = Dir.prepend(buf, scheme);
                            }
                            if (dirMatch) {
                                buf.append(SLASH);
                            }
                            if ((status2 = func.call(buf.getUnsafeBytes(), buf.begin(), buf.getRealSize(), enc, arg2)) == 0) continue;
                            break;
                        }
                        links.add(buf);
                    }
                }
                if (!links.isEmpty()) {
                    for (ByteList link2 : links) {
                        if (status2 != 0) break block0;
                        String fullPath = Convert.asJavaString(scheme != null ? Dir.prepend(link2, scheme) : link2);
                        if (!JRubyFile.createResource(runtime2, cwd, fullPath).isDirectory()) continue;
                        int linkSub = link2.begin() + link2.realSize();
                        link2.append(path2, slashIndex, end2 - slashIndex);
                        status2 = Dir.glob_helper(runtime2, cwd, scheme, link2, linkSub, flags2, func, arg2);
                    }
                    break;
                }
            }
            ptr = slashIndex;
        }
        return status2;
    }

    private static boolean isIgnorableDotOrDotDot(String file2, boolean recursive, int flags2, boolean skipdot) {
        if (file2.charAt(0) == '.') {
            int length2 = file2.length();
            if (length2 == 1) {
                return skipdot || recursive && (flags2 & 4) == 0;
            }
            return length2 == 2 && file2.charAt(1) == '.';
        }
        return false;
    }

    private static ByteList createPath(byte[] base, byte[] segment, Encoding encoding2) {
        ByteList buf = new ByteList(20);
        buf.setEncoding(encoding2);
        buf.append(base);
        if (segment != null) {
            if (!Dir.isRoot(base)) {
                buf.append(SLASH);
            }
            buf.append(segment);
        }
        return buf;
    }

    private static byte[] getBytesInUTF8(String str) {
        return RubyEncoding.encodeUTF8(str);
    }

    @Deprecated(since="9.3.0.0")
    public static int range(byte[] _pat, int pat, int pend, char test2, int flags2) {
        return new FilenameMatch(pat, 0, flags2).helper(_pat, pend, new byte[]{(byte)test2}, 1, (Encoding)ASCIIEncoding.INSTANCE);
    }

    static class FilenameMatch {
        int pcur;
        int scur;
        final int flags;
        final boolean escape;
        final boolean pathname;
        final boolean period;
        final boolean nocase;

        FilenameMatch(int pcur, int scur, int flags2) {
            this.pcur = pcur;
            this.scur = scur;
            this.flags = flags2;
            this.escape = (flags2 & 1) == 0;
            this.pathname = (flags2 & 2) != 0;
            this.period = (flags2 & 4) == 0;
            this.nocase = (flags2 & 8) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int helper(byte[] pbytes, int pend, byte[] sbytes, int send2, Encoding enc) {
            int s2 = this.scur;
            int p2 = this.pcur;
            int ptmp = -1;
            int stmp = -1;
            if (s2 < send2 && p2 < pend && this.period && sbytes[s2] == 46 && pbytes[this.unescape(pbytes, p2)] != 46) {
                return 1;
            }
            try {
                int n;
                block15: while (true) {
                    if (p2 >= pend) {
                        if (this.isEnd(sbytes, s2, send2)) {
                            n = 0;
                            return n;
                        }
                        if (ptmp != -1 && stmp != -1) {
                            p2 = ptmp;
                            s2 = ++stmp;
                            continue;
                        }
                        n = 1;
                        return n;
                    }
                    switch (pbytes[p2]) {
                        case 42: {
                            while (++p2 < pend && pbytes[p2] == 42) {
                            }
                            if (this.isEnd(pbytes, this.unescape(pbytes, p2), pend)) {
                                n = 0;
                                return n;
                            }
                            if (this.isEnd(sbytes, s2, send2)) {
                                n = 1;
                                return n;
                            }
                            ptmp = p2;
                            stmp = s2;
                            continue block15;
                        }
                        case 63: {
                            if (this.isEnd(sbytes, s2, send2)) {
                                n = 1;
                                return n;
                            }
                            ++p2;
                            s2 += StringSupport.length(enc, sbytes, s2, send2);
                            continue block15;
                        }
                        case 91: {
                            if (this.isEnd(sbytes, s2, send2)) {
                                n = 1;
                                return n;
                            }
                            int t = this.bracket(pbytes, p2 + 1, pend, sbytes, s2, send2, enc);
                            if (t == -1) break;
                            p2 = t;
                            s2 += StringSupport.length(enc, sbytes, s2, send2);
                            continue block15;
                        }
                        default: {
                            int r;
                            p2 = this.unescape(pbytes, p2);
                            if (this.isEnd(sbytes, s2, send2)) {
                                int n2 = this.isEnd(pbytes, p2, pend) ? 0 : 1;
                                return n2;
                            }
                            if (this.isEnd(pbytes, p2, pend) || !StringSupport.MBCLEN_CHARFOUND_P(r = StringSupport.preciseLength(enc, pbytes, p2, pend))) break;
                            if (r <= send2 - s2 && ByteList.memcmp(pbytes, p2, r, sbytes, s2, r) == 0) {
                                p2 += r;
                                s2 += r;
                                continue block15;
                            }
                            if (!(DOSISH && this.pathname && Dir.isdirsep(pbytes[p2]) && Dir.isdirsep(sbytes[s2]) || this.nocase && Character.toLowerCase(StringSupport.codePoint(enc, pbytes, p2, pend)) == Character.toLowerCase(StringSupport.codePoint(enc, sbytes, s2, send2)))) break;
                            p2 += r;
                            s2 += StringSupport.length(enc, sbytes, s2, send2);
                            continue block15;
                        }
                    }
                    if (ptmp == -1 || stmp == -1) break;
                    p2 = ptmp;
                    s2 = ++stmp;
                }
                n = 1;
                return n;
            }
            finally {
                this.pcur = p2;
                this.scur = s2;
            }
        }

        public int bracket(byte[] pbytes, int p2, int pend, byte[] sbytes, int s2, int send2, Encoding enc) {
            boolean not = false;
            boolean ok = false;
            if (p2 >= pend) {
                return -1;
            }
            if (pbytes[p2] == 33 || pbytes[p2] == 94) {
                not = true;
                ++p2;
            }
            while (true) {
                if (p2 >= pend) {
                    return -1;
                }
                if (pbytes[p2] == 93) break;
                int t1 = p2;
                if (this.escape && pbytes[t1] == 92) {
                    ++t1;
                }
                if (t1 >= pend) {
                    return -1;
                }
                int r = StringSupport.length(enc, pbytes, t1, pend);
                p2 = t1 + r;
                if (p2 >= pend) {
                    return -1;
                }
                if (pbytes[p2] == 45 && pbytes[p2 + 1] != 93) {
                    int t2 = p2 + 1;
                    if (this.escape && pbytes[t2] == 92) {
                        ++t2;
                    }
                    if (t2 >= pend) {
                        return -1;
                    }
                    int r2 = StringSupport.length(enc, pbytes, t2, pend);
                    p2 = t2 + r2;
                    if (ok) continue;
                    if (r <= send2 - s2 && ByteList.memcmp(pbytes, t1, r, sbytes, s2, r) == 0 || r2 <= send2 - s2 && ByteList.memcmp(pbytes, t2, r2, sbytes, s2, r2) == 0) {
                        ok = true;
                        continue;
                    }
                    c1 = StringSupport.codePoint(enc, sbytes, s2, send2);
                    if (this.nocase) {
                        c1 = Character.toUpperCase(c1);
                    }
                    c2 = StringSupport.codePoint(enc, pbytes, t1, pend);
                    if (this.nocase) {
                        c2 = Character.toUpperCase(c2);
                    }
                    if (c1 < c2) continue;
                    c2 = StringSupport.codePoint(enc, pbytes, t2, pend);
                    if (this.nocase) {
                        c2 = Character.toUpperCase(c2);
                    }
                    if (c1 > c2) {
                        continue;
                    }
                } else {
                    if (ok) continue;
                    if (r <= send2 - s2 && ByteList.memcmp(pbytes, t1, r, sbytes, s2, r) == 0) {
                        ok = true;
                        continue;
                    }
                    if (!this.nocase || (c1 = Character.toUpperCase(StringSupport.codePoint(enc, sbytes, s2, send2))) != (c2 = Character.toUpperCase(StringSupport.codePoint(enc, pbytes, p2, pend)))) continue;
                }
                ok = true;
            }
            return ok == not ? -1 : p2 + 1;
        }

        private int unescape(byte[] bytes2, int i2) {
            if (this.escape && i2 < bytes2.length && bytes2[i2] == 92) {
                return i2 + 1;
            }
            return i2;
        }

        private boolean isEnd(byte[] sbytes, int s2, int send2) {
            return s2 >= send2 || this.pathname && Dir.isdirsep(sbytes[s2]);
        }
    }

    private static class GlobPattern {
        final byte[] bytes;
        final int begin;
        final int end;
        final Encoding enc;
        private int index;
        private final int flags;

        GlobPattern(ByteList bytes2, int flags2) {
            this(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize(), bytes2.getEncoding(), flags2);
        }

        GlobPattern(byte[] bytes2, int index2, int end2, Encoding enc, int flags2) {
            this.bytes = bytes2;
            this.index = index2;
            this.begin = index2;
            this.end = end2;
            this.enc = enc;
            this.flags = flags2;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            byte rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            byte leftToken = this.bytes[leftTokenIndex];
            switch (leftToken) {
                case 123: {
                    rightToken = 125;
                    break;
                }
                case 91: {
                    rightToken = 93;
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                byte c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value2) {
            this.index = value2;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(byte c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public byte next() {
            return this.bytes[this.index++];
        }
    }

    private static class GlobArgs {
        final GlobFunc<List<ByteList>> func;
        final List<ByteList> arg;
        private int c = -1;

        GlobArgs(GlobFunc<List<ByteList>> func, List<ByteList> arg2) {
            this.func = func;
            this.arg = arg2;
        }
    }

    private static interface GlobFunc<T> {
        public int call(byte[] var1, int var2, int var3, Encoding var4, T var5);
    }

    static enum GlobMagic {
        PLAIN,
        ALPHA,
        MAGICAL;

    }
}

