/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.api.Access;
import org.jruby.api.Error;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public final class MetaClass
extends RubyClass {
    private RubyBasicObject attached;
    private static final Logger LOG = LoggerFactory.getLogger(MetaClass.class);
    private static final boolean LOG_SINGLETONS = (Boolean)Options.LOG_SINGLETONS.load();
    private static final boolean LOG_SINGLETONS_VERBOSE = (Boolean)Options.LOG_SINGLETONS_VERBOSE.load();

    @Deprecated(since="9.2.1.0")
    public MetaClass(Ruby runtime2, RubyClass superClass, IRubyObject attached) {
        this(runtime2, superClass, (RubyBasicObject)attached);
    }

    MetaClass(Ruby runtime2, RubyClass superClass, RubyBasicObject attached) {
        super(runtime2, superClass, false);
        this.metaClassInit(superClass, attached);
        if (LOG_SINGLETONS || LOG_SINGLETONS_VERBOSE) {
            MetaClass.logSingleton(runtime2, superClass, attached);
        }
    }

    MetaClass(Ruby runtime2, RubyClass superClass, RubyClass Class2, RubyBasicObject attached) {
        super(runtime2, superClass, Class2);
        this.metaClassInit(superClass, attached);
    }

    private void metaClassInit(RubyClass superClass, RubyBasicObject attached) {
        this.attached = attached;
        this.classIndex(superClass.getClassIndex());
        superClass.addSubclass(this);
    }

    private static void logSingleton(Ruby runtime2, RubyClass superClass, RubyBasicObject attached) {
        if (runtime2.isBooting()) {
            return;
        }
        String attachedString = attached == null ? "null object" : "object of type " + String.valueOf(attached.getMetaClass());
        LOG.info("singleton class created for type " + String.valueOf(superClass) + " attached to " + attachedString, new Object[0]);
        if (LOG_SINGLETONS_VERBOSE) {
            LOG.info(new Exception("singleton creation stack trace"));
        }
    }

    @Override
    public final IRubyObject allocate(ThreadContext context) {
        throw Error.typeError(context, "can't create instance of virtual class");
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public RubyClass makeMetaClass(ThreadContext context, RubyClass superClass) {
        MetaClass klass = new MetaClass(context.runtime, this.getSuperSingletonMetaClass(context), (RubyBasicObject)this);
        this.setMetaClass(klass);
        klass.setMetaClass(klass);
        return klass;
    }

    private RubyClass getSuperSingletonMetaClass(ThreadContext context) {
        RubyBasicObject rubyBasicObject = this.attached;
        if (rubyBasicObject instanceof RubyClass) {
            RubyClass att = (RubyClass)rubyBasicObject;
            RubyClass superClass = att.superClass();
            if (superClass != null) {
                superClass = superClass.getRealClass();
            }
            return superClass == null ? Access.classClass(context).singletonClass(context) : superClass.getMetaClass().singletonClass(context);
        }
        return this.getSuperClass().getRealClass().getMetaClass();
    }

    @Override
    RubyClass toSingletonClass(ThreadContext context, RubyBasicObject target2) {
        return this.attached == target2 ? this : super.toSingletonClass(context, target2);
    }

    @Override
    public IRubyObject attached_object(ThreadContext context) {
        return this.attached;
    }

    public RubyBasicObject getAttached() {
        return this.attached;
    }

    public void setAttached(RubyBasicObject attached) {
        this.attached = attached;
    }
}

