/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jay.yydebug.yyDebug;

public class yyAnimPanel
extends Panel
implements yyDebug {
    protected transient TextField token;
    protected transient TextField value;
    protected transient TextArea comments;
    protected transient Stack stack;
    protected transient boolean tokenBreak = true;
    protected transient boolean stackBreak;
    protected transient boolean commentsBreak;

    public yyAnimPanel(Font font) {
        super(new BorderLayout());
        Panel p = new Panel(new BorderLayout());
        Checkbox c = new Checkbox("token ", this.tokenBreak);
        p.add((Component)c, "West");
        c.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                yyAnimPanel.this.tokenBreak = ie.getStateChange() == 1;
            }
        });
        Panel q = new Panel(new BorderLayout());
        this.token = new TextField(12);
        q.add((Component)this.token, "West");
        this.token.setEditable(false);
        this.token.setBackground(Color.white);
        this.token.setFont(font);
        this.value = new TextField(24);
        q.add((Component)this.value, "Center");
        this.value.setEditable(false);
        this.value.setBackground(Color.white);
        this.value.setFont(font);
        p.add((Component)q, "Center");
        Button b = new Button(" continue ");
        p.add((Component)b, "East");
        b.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ae) {
                yyAnimPanel yyAnimPanel2 = yyAnimPanel.this;
                synchronized (yyAnimPanel2) {
                    yyAnimPanel.this.notify();
                }
            }
        });
        this.add((Component)p, "North");
        p = new Panel(new BorderLayout());
        q = new Panel(new BorderLayout());
        c = new Checkbox("stack", this.stackBreak);
        q.add((Component)c, "North");
        c.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                yyAnimPanel.this.stackBreak = ie.getStateChange() == 1;
            }
        });
        this.stack = new Stack(font);
        q.add((Component)this.stack, "Center");
        p.add((Component)q, "Center");
        q = new Panel(new BorderLayout());
        c = new Checkbox("comments", this.commentsBreak);
        q.add((Component)c, "North");
        c.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                yyAnimPanel.this.commentsBreak = ie.getStateChange() == 1;
            }
        });
        this.comments = new TextArea(10, 40);
        q.add((Component)this.comments, "Center");
        this.comments.setEditable(false);
        this.comments.setBackground(Color.white);
        this.comments.setFont(font);
        p.add((Component)q, "East");
        this.add((Component)p, "Center");
    }

    protected synchronized void explain(String what) {
        if (this.comments.getText().length() > 0) {
            this.comments.append("\n");
        }
        this.comments.append(what);
        if (this.commentsBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void lex(int state, int token, String name, Object value) {
        this.token.setText(name);
        this.value.setText(value == null ? "" : value.toString());
        this.explain("read " + name);
        if (this.tokenBreak && !this.commentsBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public void shift(int from, int to, int errorFlag) {
        switch (errorFlag) {
            default: {
                this.explain("shift to " + to);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.explain("shift to " + to + ", " + errorFlag + " left to recover");
                break;
            }
            case 3: {
                this.explain("shift to " + to + " on error");
            }
        }
    }

    public void discard(int state, int token, String name, Object value) {
        this.explain("discard token " + name + ", value " + value);
    }

    public void shift(int from, int to) {
        this.explain("go to " + to);
    }

    public synchronized void accept(Object value) {
        this.explain("accept, value " + value);
        this.stack.pop();
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void error(String message) {
        this.explain("error message");
    }

    public void reject() {
        this.explain("reject");
        this.stack.pop();
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void push(int state, Object value) {
        this.stack.push(state, value);
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void pop(int state) {
        this.explain("pop " + state + " on error");
        this.stack.pop(1);
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void reduce(int from, int to, int rule, String text, int len) {
        this.explain("reduce (" + rule + "), uncover " + to + "\n(" + rule + ") " + text);
        this.stack.pop(len);
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    protected static final class Stack
    extends ScrollPane {
        protected static final GridBagConstraints level = new GridBagConstraints();
        protected final Font font;
        protected final Panel panel;

        public Stack(Font font) {
            super(0);
            this.font = font;
            this.setSize(50, 100);
            this.panel = new Panel(new GridBagLayout());
            this.add(this.panel);
        }

        public void push(int state, Object value) {
            Panel q = new Panel(new BorderLayout());
            TextField t = new TextField("" + state, 5);
            q.add((Component)t, "West");
            t.setEditable(false);
            t.setBackground(Color.white);
            t.setFont(this.font);
            t = new TextField(value != null ? value.toString() : "");
            q.add((Component)t, "Center");
            t.setEditable(false);
            t.setBackground(Color.white);
            t.setFont(this.font);
            this.panel.add(q, level, 0);
            this.validate();
        }

        public void pop(int len) {
            for (int n = 0; n < len; ++n) {
                this.panel.remove(0);
                this.validate();
            }
        }

        public void pop() {
            this.panel.removeAll();
            this.validate();
        }

        static {
            Stack.level.anchor = 11;
            Stack.level.fill = 2;
            Stack.level.gridheight = 1;
            Stack.level.gridwidth = 0;
            Stack.level.gridx = 0;
            Stack.level.gridy = -1;
            Stack.level.weightx = 1.0;
        }
    }
}

