/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.PrintStream;
import jay.yydebug.yyAnimPanel;
import jay.yydebug.yyDebug;
import jay.yydebug.yyInputStream;
import jay.yydebug.yyPrintStream;

public class yyAnim
extends Frame
implements yyDebug {
    protected static int nFrames;
    public static final int IN = 1;
    public static final int OUT = 2;
    protected yyAnimPanel panel;
    protected Thread eventThread;
    protected boolean outputBreak;

    public yyAnim(String title, int io) {
        this(System.class, title, io);
    }

    public yyAnim(final Class system, String title, int io) {
        super(title);
        ++nFrames;
        this.outputBreak = false;
        Font font = new Font("Monospaced", 0, 12);
        MenuBar mb = new MenuBar();
        Menu m = new Menu("yyAnim");
        MenuItem mi = new MenuItem("Quit");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    system.getMethod("exit", Integer.TYPE).invoke(null, new Integer(0));
                }
                catch (Exception e) {
                    System.exit(0);
                }
            }
        });
        m.add(mi);
        mb.add(m);
        this.setMenuBar(mb);
        this.panel = new yyAnimPanel(font);
        this.add((Component)this.panel, "Center");
        if ((io & 3) != 0) {
            Panel p = new Panel(new BorderLayout());
            switch (io) {
                case 1: {
                    p.add((Component)new Label("terminal input"), "North");
                    break;
                }
                case 2: 
                case 3: {
                    String ct = (io & 1) != 0 ? "terminal i/o" : "terminal output";
                    Checkbox c = new Checkbox(ct, this.outputBreak);
                    p.add((Component)c, "North");
                    c.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent ie) {
                            yyAnim.this.eventThread = Thread.currentThread();
                            yyAnim.this.outputBreak = ie.getStateChange() == 1;
                        }
                    });
                }
            }
            final TextArea t = new TextArea(10, 50);
            p.add((Component)t, "Center");
            t.setBackground(Color.white);
            t.setFont(font);
            if ((io & 1) != 0) {
                yyInputStream in = new yyInputStream();
                t.addKeyListener(in);
                t.setEditable(true);
                try {
                    system.getMethod("setIn", InputStream.class).invoke(null, in);
                }
                catch (Exception e) {
                    System.setIn(in);
                }
            }
            if ((io & 2) != 0) {
                yyPrintStream out = new yyPrintStream(){

                    public void close() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void write(byte[] b, int off, int len) {
                        String s = new String(b, off, len);
                        t.append(s);
                        t.setCaretPosition(t.getText().length());
                        if (yyAnim.this.outputBreak && s.indexOf("\n") >= 0 && yyAnim.this.eventThread != null && Thread.currentThread() != yyAnim.this.eventThread) {
                            try {
                                yyAnimPanel yyAnimPanel2 = yyAnim.this.panel;
                                synchronized (yyAnimPanel2) {
                                    yyAnim.this.panel.wait();
                                }
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                    }

                    public void write(int b) {
                        this.write(new byte[]{(byte)b}, 0, 1);
                    }
                };
                try {
                    system.getMethod("setOut", PrintStream.class).invoke(null, out);
                }
                catch (Exception e) {
                    System.setOut(out);
                }
                try {
                    system.getMethod("setErr", PrintStream.class).invoke(null, out);
                }
                catch (Exception e) {
                    System.setErr(out);
                }
            }
            this.add((Component)p, "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                yyAnim.this.dispose();
                if (--nFrames <= 0) {
                    try {
                        system.getMethod("exit", Integer.TYPE).invoke(null, new Integer(0));
                    }
                    catch (Exception e) {
                        System.exit(0);
                    }
                }
            }
        });
        this.pack();
        yyAnim.setStaggeredLocation(this);
        this.show();
    }

    public static void setStaggeredLocation(Component c) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = c.getPreferredSize();
        int x = (screen.width - d.width) / 2 + (nFrames - 1) * 32;
        if (x < 32) {
            x = 32;
        } else if (x > screen.width - 128) {
            x = screen.width - 128;
        }
        int y = (screen.height - d.height) / 2 + (nFrames - 1) * 32;
        if (y < 32) {
            y = 32;
        } else if (y > screen.height - 128) {
            y = screen.height - 128;
        }
        c.setLocation(x, y);
    }

    public synchronized void lex(int state, int token, String name, Object value) {
        this.panel.lex(state, token, name, value);
    }

    public void shift(int from, int to, int errorFlag) {
        this.panel.shift(from, to, errorFlag);
    }

    public void discard(int state, int token, String name, Object value) {
        this.panel.discard(state, token, name, value);
    }

    public void shift(int from, int to) {
        this.panel.shift(from, to);
    }

    public synchronized void accept(Object value) {
        this.panel.accept(value);
    }

    public void error(String message) {
        this.panel.error(message);
    }

    public void reject() {
        this.panel.reject();
    }

    public synchronized void push(int state, Object value) {
        this.panel.push(state, value);
    }

    public synchronized void pop(int state) {
        this.panel.pop(state);
    }

    public synchronized void reduce(int from, int to, int rule, String text, int len) {
        this.panel.reduce(from, to, rule, text, len);
    }
}

