/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.struct.Struct;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;
import jnr.netdb.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeServicesDB
implements ServicesDB {
    private final LibServices lib;

    public NativeServicesDB(LibServices lib) {
        this.lib = lib;
    }

    public static final NativeServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static final NativeServicesDB load() {
        try {
            LibServices lib;
            Platform.OS os = Platform.getPlatform().getOS();
            if (!(os.equals((Object)Platform.OS.DARWIN) || os.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || os.equals((Object)Platform.OS.LINUX) || os.equals((Object)Platform.OS.SOLARIS) || os.equals((Object)Platform.OS.FREEBSD) || os.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> options = new HashMap<LibraryOption, CallingConvention>();
                options.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                lib = (LibServices)Library.loadLibrary(LibServices.class, options, (String[])new String[]{"Ws2_32"});
            } else {
                String[] stringArray;
                if (os.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] libnames = stringArray;
                lib = (LibServices)Library.loadLibrary(LibServices.class, (String[])libnames);
            }
            lib.getservbyname("bootps", "udp");
            lib.getservbyport(67, "udp");
            return new NativeServicesDB(lib);
        }
        catch (Throwable t) {
            Logger.getLogger(NativeServicesDB.class.getName()).log(Level.WARNING, "Failed to load native services db", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Service> getAllServices() {
        ArrayList<Service> allServices = new ArrayList<Service>();
        try {
            UnixServent s;
            while ((s = this.lib.getservent()) != null) {
                allServices.add(this.serviceFromNative(s));
            }
        }
        finally {
            this.lib.endservent();
        }
        return allServices;
    }

    private final Service serviceFromNative(UnixServent s) {
        int port;
        if (s == null) {
            return null;
        }
        int n = port = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)s.port.get()) : s.port.get();
        if (port < 0) {
            port = (port & Short.MAX_VALUE) + 32768;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = s.aliases.get();
        List<String> aliases = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return s != null ? new Service(s.name.get(), port, s.proto.get(), aliases) : null;
    }

    @Override
    public Service getServiceByName(String name, String proto) {
        return this.serviceFromNative(this.lib.getservbyname(name, proto));
    }

    @Override
    public Service getServiceByPort(Integer port, String proto) {
        short nport = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? Short.reverseBytes(port.shortValue()) : port.shortValue();
        return this.serviceFromNative(this.lib.getservbyport(Integer.valueOf(nport), proto));
    }

    public static interface LibServices {
        public UnixServent getservbyname(String var1, String var2);

        public UnixServent getservbyport(Integer var1, String var2);

        public UnixServent getservent();

        public void endservent();
    }

    public static class UnixServent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef((Struct)this);
        public final Struct.Pointer aliases = new Struct.Pointer((Struct)this);
        public final Struct.Signed32 port = new Struct.Signed32((Struct)this);
        public final Struct.String proto = new Struct.UTF8StringRef((Struct)this);
    }

    private static final class SingletonHolder {
        public static final NativeServicesDB INSTANCE = NativeServicesDB.load();

        private SingletonHolder() {
        }
    }
}

