/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;

final class Init {
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", Foreign.VERSION_MAJOR, Foreign.VERSION_MINOR);

    Init() {
    }

    static final void init() {
    }

    private static final void load() {
        String libName = Init.getStubLibraryName();
        String bootPath = Init.getBootPath();
        if (bootPath != null && Init.loadFromBootPath(libName, bootPath)) {
            return;
        }
        try {
            System.loadLibrary(libName);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Init.loadFromJar();
            return;
        }
    }

    private static final String getBootPath() {
        String bootPath = System.getProperty(bootLibraryPropertyName);
        if (bootPath != null) {
            return bootPath;
        }
        InputStream is = Init.class.getResourceAsStream(bootPropertyFilename);
        if (is != null) {
            Properties p = new Properties();
            try {
                p.load(is);
                return p.getProperty(bootLibraryPropertyName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final boolean loadFromBootPath(String libName, String bootPath) {
        String[] dirs = bootPath.split(File.pathSeparator);
        for (int i = 0; i < dirs.length; ++i) {
            String path = new File(new File(dirs[i]), System.mapLibraryName(libName)).getAbsolutePath();
            try {
                System.load(path);
                return true;
            }
            catch (UnsatisfiedLinkError ex) {
                String ext;
                String orig;
                if (Platform.getPlatform().getOS() != Platform.OS.DARWIN) continue;
                if (path.endsWith("dylib")) {
                    orig = "dylib";
                    ext = "jnilib";
                } else {
                    orig = "jnilib";
                    ext = "dylib";
                }
                try {
                    System.load(path.substring(0, path.lastIndexOf(orig)) + ext);
                    return true;
                }
                catch (UnsatisfiedLinkError ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    private static final void loadFromJar() {
        InputStream is = Init.getStubLibraryStream();
        File dstFile = null;
        try {
            dstFile = File.createTempFile("jffi", null);
            dstFile.deleteOnExit();
            FileChannel dstChannel = new FileOutputStream(dstFile).getChannel();
            ReadableByteChannel srcChannel = Channels.newChannel(is);
            long pos = 0L;
            while (is.available() > 0) {
                pos += dstChannel.transferFrom(srcChannel, pos, Math.max(4096, is.available()));
            }
            dstChannel.close();
            System.load(dstFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
    }

    private static final InputStream getStubLibraryStream() {
        String path = Init.getStubLibraryPath();
        InputStream is = Init.class.getResourceAsStream(path);
        if (is == null && Platform.getPlatform().getOS() == Platform.OS.DARWIN) {
            is = Init.class.getResourceAsStream(path.replaceAll("dylib", "jnilib"));
        }
        if (is == null) {
            throw new UnsatisfiedLinkError("Could not locate stub library (" + path + ") in jar file");
        }
        return is;
    }

    private static final String getStubLibraryName() {
        return stubLibraryName;
    }

    private static final String getStubLibraryPath() {
        return "/jni/" + Platform.getPlatform().getName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    static {
        Init.load();
    }
}

