/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Type;

public final class CallContext
implements CallInfo {
    private final Type returnType;
    private final Type[] parameterTypes;
    final int flags;
    final long nativeReturnType;
    final long[] nativeParameterTypes;

    public CallContext(Type returnType, Type ... paramTypes) {
        this(returnType, paramTypes, CallingConvention.DEFAULT, true);
    }

    public CallContext(Type returnType, Type[] paramTypes, CallingConvention convention) {
        this(returnType, paramTypes, convention, true);
    }

    public CallContext(Type returnType, Type[] paramTypes, CallingConvention convention, boolean saveErrno) {
        this.flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0);
        this.returnType = returnType;
        this.parameterTypes = (Type[])paramTypes.clone();
        this.nativeReturnType = returnType.handle();
        this.nativeParameterTypes = Type.nativeHandles(paramTypes);
    }

    public final int getParameterCount() {
        return this.parameterTypes.length;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int index) {
        return this.parameterTypes[index];
    }

    public final synchronized void dispose() {
    }
}

