/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Address;
import com.kenai.jffi.Foreign;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object lock = new Object();
    private static final ThreadLocal<String> lastError = new ThreadLocal();
    public static final int LAZY = 1;
    public static final int NOW = 2;
    public static final int LOCAL = 4;
    public static final int GLOBAL = 8;
    private final long handle;
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long dlopen(String name, int flags) {
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            long address = foreign.dlopen(name, flags);
            if (address == 0L) {
                lastError.set(foreign.dlerror());
            }
            return address;
        }
    }

    public static final Library getDefault() {
        return DefaultLibrary.INSTANCE;
    }

    public static final Library getCachedInstance(String name, int flags) {
        Library lib;
        if (name == null) {
            return Library.getDefault();
        }
        WeakReference<Library> ref = cache.get(name);
        if (ref != null && (lib = (Library)ref.get()) != null) {
            return lib;
        }
        long address = Library.dlopen(name, flags);
        if (address == 0L) {
            return null;
        }
        lib = new Library(name, address);
        cache.put(name, new WeakReference<Library>(lib));
        return lib;
    }

    public static final Library openLibrary(String name, int flags) {
        long address = Library.dlopen(name, flags);
        return address != 0L ? new Library(name, address) : null;
    }

    private Library(String name, long address) {
        this.name = name;
        this.handle = address;
    }

    @Deprecated
    public Library(String name, int flags) {
        this.name = name;
        this.handle = Library.dlopen(name, flags);
        if (this.handle == 0L) {
            String error = String.format("Could not open [%s]: %s", name, Library.getLastError());
            throw new UnsatisfiedLinkError(error);
        }
    }

    @Deprecated
    public final Address findSymbol(String name) {
        return new Address(this.getSymbolAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSymbolAddress(String name) {
        Foreign foreign = Foreign.getInstance();
        Object object = lock;
        synchronized (object) {
            long address = foreign.dlsym(this.handle, name);
            if (address == 0L) {
                lastError.set(foreign.dlerror());
            }
            return address;
        }
    }

    @Deprecated
    public static final String lastError() {
        return Library.getLastError();
    }

    public static final String getLastError() {
        String error = lastError.get();
        return error != null ? error : "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.handle != 0L) {
                Foreign.getInstance().dlclose(this.handle);
            }
        }
        finally {
            super.finalize();
        }
    }

    private static final class DefaultLibrary {
        private static final Library INSTANCE = new Library(null, 1);

        private DefaultLibrary() {
        }
    }
}

