/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.NullMemoryIO;
import com.kenai.jaffl.provider.StringIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class DirectMemoryIO
extends AbstractMemoryIO {
    static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
    protected final long address;

    DirectMemoryIO(long address) {
        this.address = address;
    }

    public final long address() {
        return this.address;
    }

    public final byte getByte(long offset) {
        return IO.getByte(this.address + offset);
    }

    public final short getShort(long offset) {
        return IO.getShort(this.address + offset);
    }

    public final int getInt(long offset) {
        return IO.getInt(this.address + offset);
    }

    public final long getLong(long offset) {
        return IO.getLong(this.address + offset);
    }

    public final float getFloat(long offset) {
        return IO.getFloat(this.address + offset);
    }

    public final double getDouble(long offset) {
        return IO.getDouble(this.address + offset);
    }

    public final void putByte(long offset, byte value) {
        IO.putByte(this.address + offset, value);
    }

    public final void putShort(long offset, short value) {
        IO.putShort(this.address + offset, value);
    }

    public final void putInt(long offset, int value) {
        IO.putInt(this.address + offset, value);
    }

    public final void putLong(long offset, long value) {
        IO.putLong(this.address + offset, value);
    }

    public final void putFloat(long offset, float value) {
        IO.putFloat(this.address + offset, value);
    }

    public final void putDouble(long offset, double value) {
        IO.putDouble(this.address + offset, value);
    }

    public final void get(long offset, byte[] dst, int off, int len) {
        IO.getByteArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, byte[] src, int off, int len) {
        IO.putByteArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, short[] dst, int off, int len) {
        IO.getShortArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, short[] src, int off, int len) {
        IO.putShortArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, int[] dst, int off, int len) {
        IO.getIntArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, int[] src, int off, int len) {
        IO.putIntArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, long[] dst, int off, int len) {
        IO.getLongArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, long[] src, int off, int len) {
        IO.putLongArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, float[] dst, int off, int len) {
        IO.getFloatArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, float[] src, int off, int len) {
        IO.putFloatArray(this.address + offset, src, off, len);
    }

    public final void get(long offset, double[] dst, int off, int len) {
        IO.getDoubleArray(this.address + offset, dst, off, len);
    }

    public final void put(long offset, double[] src, int off, int len) {
        IO.putDoubleArray(this.address + offset, src, off, len);
    }

    public MemoryIO getMemoryIO(long offset) {
        return MemoryUtil.newMemoryIO(IO.getAddress(this.address + offset));
    }

    public MemoryIO getMemoryIO(long offset, long size) {
        long ptr = IO.getAddress(this.address + offset);
        return ptr != 0L ? new BoundedDirectMemoryIO(new DirectMemoryIO(ptr), 0L, size) : new NullMemoryIO();
    }

    public Pointer getPointer(long offset) {
        return MemoryUtil.newPointer(IO.getAddress(this.address + offset));
    }

    public void putPointer(long offset, Pointer value) {
        IO.putAddress(this.address + offset, value.address());
    }

    public String getString(long offset) {
        byte[] bytes = IO.getZeroTerminatedByteArray(this.address + offset);
        return ((Object)StringIO.getStringIO().fromNative(ByteBuffer.wrap(bytes))).toString();
    }

    public String getString(long offset, int maxLength, Charset cs) {
        byte[] bytes = IO.getZeroTerminatedByteArray(this.address + offset, maxLength);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return ((Object)StringIO.getStringIO().fromNative(buf)).toString();
    }

    public void putString(long offset, String string, int maxLength, Charset cs) {
        ByteBuffer buf = StringIO.getStringIO().toNative(string, 0, true);
        IO.putByteArray(this.address + offset, buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
    }

    public int indexOf(long offset, byte value, int maxlen) {
        return (int)IO.indexOf(this.address + offset, value, maxlen);
    }

    public final boolean isDirect() {
        return true;
    }

    public final void setMemory(long offset, long size, byte value) {
        IO.setMemory(this.address + offset, size, value);
    }
}

