/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.FunctionMapper;
import com.kenai.jaffl.mapper.MethodParameterContext;
import com.kenai.jaffl.mapper.MethodResultContext;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.InvocationSession;
import com.kenai.jaffl.provider.jffi.AsmLoader;
import com.kenai.jaffl.provider.jffi.AsmUtil;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.EnumResultConverter;
import com.kenai.jaffl.provider.jffi.IdentityFunctionMapper;
import com.kenai.jaffl.provider.jffi.InvokerUtil;
import com.kenai.jaffl.provider.jffi.Library;
import com.kenai.jaffl.provider.jffi.LibraryLoader;
import com.kenai.jaffl.provider.jffi.MarshalUtil;
import com.kenai.jaffl.provider.jffi.NullTypeMapper;
import com.kenai.jaffl.provider.jffi.NumberUtil;
import com.kenai.jaffl.provider.jffi.SkinnyMethodAdapter;
import com.kenai.jaffl.provider.jffi.SymbolNotFoundError;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLibraryLoader
extends LibraryLoader
implements Opcodes {
    public static final boolean DEBUG = Boolean.getBoolean("jaffl.compile.dump");
    private static final LibraryLoader INSTANCE = new AsmLibraryLoader();
    private static final boolean FAST_NUMERIC_AVAILABLE = AsmLibraryLoader.isFastNumericAvailable();
    private final AtomicLong nextClassID = new AtomicLong(0L);
    private final AtomicLong nextIvarID = new AtomicLong(0L);

    static final LibraryLoader getInstance() {
        return INSTANCE;
    }

    @Override
    boolean isInterfaceSupported(Class interfaceClass, Map<LibraryOption, ?> options) {
        TypeMapper typeMapper = options.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)options.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        for (Method m : interfaceClass.getDeclaredMethods()) {
            if (!this.isReturnTypeSupported(m.getReturnType()) && this.getResultConverter(m, typeMapper) == null) {
                System.err.println("Unsupported return type: " + m.getReturnType());
                return false;
            }
            for (Class<?> c : m.getParameterTypes()) {
                if (this.isParameterTypeSupported(c) || typeMapper.getToNativeConverter(c) != null) continue;
                System.err.println("Unsupported parameter type: " + c);
                return false;
            }
        }
        return true;
    }

    private boolean isReturnTypeSupported(Class type) {
        return type.isPrimitive() || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Pointer.class == type || Address.class == type || String.class == type || Struct.class.isAssignableFrom(type);
    }

    private boolean isParameterTypeSupported(Class type) {
        return type.isPrimitive() || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type || NativeLong.class == type || Pointer.class.isAssignableFrom(type) || Address.class.isAssignableFrom(type) || Enum.class.isAssignableFrom(type) || Buffer.class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive() || Struct.class.isAssignableFrom(type) || type.isArray() && Struct.class.isAssignableFrom(type.getComponentType()) || type.isArray() && Pointer.class.isAssignableFrom(type.getComponentType()) || CharSequence.class.isAssignableFrom(type) || ByReference.class.isAssignableFrom(type) || StringBuilder.class.isAssignableFrom(type) || StringBuffer.class.isAssignableFrom(type);
    }

    @Override
    <T> T loadLibrary(Library library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return this.generateInterfaceImpl(library, interfaceClass, libraryOptions);
    }

    private final <T> T generateInterfaceImpl(Library library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        ClassWriter cw = new ClassWriter(2);
        ClassWriter cv = DEBUG ? AsmUtil.newCheckClassAdapter(AsmUtil.newTraceClassVisitor((ClassVisitor)cw, System.out)) : cw;
        String className = CodegenUtils.p(interfaceClass) + "$jaffl$" + this.nextClassID.getAndIncrement();
        cv.visit(49, 17, className, null, CodegenUtils.p(AbstractNativeInterface.class), new String[]{CodegenUtils.p(interfaceClass)});
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, Library.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[][].class), null, null));
        init.start();
        init.aload(0);
        init.aload(1);
        init.invokespecial(CodegenUtils.p(AbstractNativeInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, Library.class));
        Method[] methods = interfaceClass.getMethods();
        Function[] functions = new Function[methods.length];
        FromNativeConverter[] resultConverters = new FromNativeConverter[methods.length];
        ToNativeConverter[][] parameterConverters = new ToNativeConverter[methods.length][0];
        FunctionMapper functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.INSTANCE;
        TypeMapper typeMapper = libraryOptions.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)libraryOptions.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        CallingConvention convention = AsmLibraryLoader.getCallingConvention(interfaceClass, libraryOptions);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            Class<?> returnType = m.getReturnType();
            Class[] parameterTypes = m.getParameterTypes();
            Class<Object> nativeReturnType = returnType;
            Class[] nativeParameterTypes = new Class[parameterTypes.length];
            boolean conversionRequired = false;
            resultConverters[i] = this.getResultConverter(m, typeMapper);
            if (resultConverters[i] != null) {
                cv.visitField(18, this.getResultConverterFieldName(i), CodegenUtils.ci(FromNativeConverter.class), null, null);
                nativeReturnType = resultConverters[i].nativeType();
                conversionRequired = true;
            }
            parameterConverters[i] = new ToNativeConverter[parameterTypes.length];
            for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
                ToNativeConverter converter = typeMapper.getToNativeConverter(parameterTypes[pidx]);
                if (converter != null) {
                    cv.visitField(18, this.getParameterConverterFieldName(i, pidx), CodegenUtils.ci(ToNativeConverter.class), null, null);
                    nativeParameterTypes[pidx] = converter.nativeType();
                    parameterConverters[i][pidx] = new ToNativeProxy(converter, new MethodParameterContext(m, pidx));
                    conversionRequired = true;
                    continue;
                }
                nativeParameterTypes[pidx] = parameterTypes[pidx];
            }
            String functionName = functionMapper.mapFunctionName(m.getName(), null);
            cv.visitField(26, "name_" + i, CodegenUtils.ci(String.class), null, (Object)functionName);
            try {
                functions[i] = AsmLibraryLoader.getFunction(library.findSymbolAddress(functionName), nativeReturnType, nativeParameterTypes, InvokerUtil.requiresErrno(m), m.getAnnotation(StdCall.class) != null ? CallingConvention.STDCALL : convention);
            }
            catch (SymbolNotFoundError ex) {
                cv.visitField(26, "error_" + i, CodegenUtils.ci(String.class), null, (Object)ex.getMessage());
                this.generateFunctionNotFound((ClassVisitor)cv, className, i, functionName, returnType, parameterTypes);
                continue;
            }
            String functionFieldName = "function_" + i;
            cv.visitField(18, functionFieldName, CodegenUtils.ci(Function.class), null, null);
            boolean ignoreErrno = !InvokerUtil.requiresErrno(m);
            this.generateMethod((ClassVisitor)cv, className, m.getName() + (conversionRequired ? "$raw" : ""), functionFieldName, m, nativeReturnType, nativeParameterTypes, m.getParameterAnnotations(), ignoreErrno);
            if (conversionRequired) {
                this.generateConversionMethod((ClassVisitor)cv, className, m.getName(), i, returnType, parameterTypes, nativeReturnType, nativeParameterTypes);
            }
            init.aload(0);
            init.aload(2);
            init.pushInt(i);
            init.aaload();
            init.putfield(className, functionFieldName, CodegenUtils.ci(Function.class));
            if (resultConverters[i] != null) {
                init.aload(0);
                init.aload(3);
                init.pushInt(i);
                init.aaload();
                init.putfield(className, this.getResultConverterFieldName(i), CodegenUtils.ci(FromNativeConverter.class));
            }
            for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
                if (parameterConverters[i][pidx] == null) continue;
                init.aload(0);
                init.aload(4);
                init.pushInt(i);
                init.aaload();
                init.pushInt(pidx);
                init.aaload();
                init.putfield(className, this.getParameterConverterFieldName(i, pidx), CodegenUtils.ci(ToNativeConverter.class));
            }
        }
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        cv.visitEnd();
        try {
            Class implClass = new AsmLoader().defineClass(className.replace("/", "."), cw.toByteArray());
            Constructor cons = implClass.getDeclaredConstructor(Library.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[][].class);
            return cons.newInstance(new Object[]{library, functions, resultConverters, parameterConverters});
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private final FromNativeConverter getResultConverter(Method m, TypeMapper typeMapper) {
        Class<?> returnType = m.getReturnType();
        FromNativeConverter conv = typeMapper.getFromNativeConverter(returnType);
        if (conv != null) {
            return new FromNativeProxy(conv, new MethodResultContext(m));
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return new EnumResultConverter(returnType);
        }
        return null;
    }

    private static final CallingConvention getCallingConvention(Class interfaceClass, Map<LibraryOption, ?> options) {
        if (interfaceClass.getAnnotation(StdCall.class) != null) {
            return CallingConvention.STDCALL;
        }
        return InvokerUtil.getCallingConvention(options);
    }

    private final String getFunctionFieldName(int idx) {
        return "function_" + idx;
    }

    private final String getResultConverterFieldName(int idx) {
        return "resultConverter_" + idx;
    }

    private final String getParameterConverterFieldName(int idx, int paramIndex) {
        return "parameterConverter_" + idx + "_" + paramIndex;
    }

    private final void generateFunctionNotFound(ClassVisitor cv, String className, int idx, String functionName, Class returnType, Class[] parameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        mv.newobj(CodegenUtils.p(UnsatisfiedLinkError.class));
        mv.dup();
        mv.getstatic(className, "error_" + idx, CodegenUtils.ci(String.class));
        mv.invokespecial(CodegenUtils.p(UnsatisfiedLinkError.class), "<init>", CodegenUtils.sig(Void.TYPE, String.class));
        mv.athrow();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    private final void generateConversionMethod(ClassVisitor cv, String className, String functionName, int idx, Class returnType, Class[] parameterTypes, Class nativeReturnType, Class[] nativeParameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        if (!returnType.equals(nativeReturnType)) {
            mv.aload(0);
            mv.getfield(className, this.getResultConverterFieldName(idx), CodegenUtils.ci(FromNativeConverter.class));
        }
        mv.aload(0);
        int lvar = 1;
        for (int pidx = 0; pidx < parameterTypes.length; ++pidx) {
            boolean convertParameter;
            boolean bl = convertParameter = !parameterTypes[pidx].equals(nativeParameterTypes[pidx]);
            if (convertParameter) {
                mv.aload(0);
                mv.getfield(className, this.getParameterConverterFieldName(idx, pidx), CodegenUtils.ci(ToNativeConverter.class));
            }
            lvar = this.loadParameter(mv, parameterTypes[pidx], lvar);
            if (!convertParameter) continue;
            if (parameterTypes[pidx].isPrimitive()) {
                this.boxPrimitive(mv, parameterTypes[pidx]);
            }
            mv.aconst_null();
            mv.invokeinterface(CodegenUtils.p(ToNativeConverter.class), "toNative", CodegenUtils.sig(Object.class, Object.class, ToNativeContext.class));
            mv.checkcast(CodegenUtils.p(nativeParameterTypes[pidx]));
        }
        mv.invokevirtual(className, functionName + "$raw", CodegenUtils.sig(nativeReturnType, nativeParameterTypes));
        if (!returnType.equals(nativeReturnType)) {
            if (nativeReturnType.isPrimitive()) {
                this.boxPrimitive(mv, nativeReturnType);
            }
            mv.aconst_null();
            mv.invokeinterface(CodegenUtils.p(FromNativeConverter.class), "fromNative", CodegenUtils.sig(Object.class, Object.class, FromNativeContext.class));
            mv.checkcast(CodegenUtils.p(returnType));
        }
        this.emitReturnOp(mv, returnType);
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    private final void generateMethod(ClassVisitor cv, String className, String functionName, String functionFieldName, Method m, Class returnType, Class[] parameterTypes, Annotation[][] parameterAnnotations, boolean ignoreErrno) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv.visitMethod(17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null));
        mv.start();
        mv.getstatic(CodegenUtils.p(AbstractNativeInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
        mv.aload(0);
        mv.getfield(className, functionFieldName, CodegenUtils.ci(Function.class));
        if (AsmLibraryLoader.isFastIntMethod(returnType, parameterTypes)) {
            this.generateFastIntInvocation(mv, returnType, parameterTypes, ignoreErrno);
        } else if (FAST_NUMERIC_AVAILABLE && AsmLibraryLoader.isFastNumericMethod(returnType, parameterTypes)) {
            this.generateFastNumericInvocation(mv, returnType, parameterTypes);
        } else {
            this.generateBufferInvocation(mv, returnType, parameterTypes, parameterAnnotations);
        }
        mv.visitMaxs(100, AsmLibraryLoader.getTotalParameterSize(parameterTypes) + 10);
        mv.visitEnd();
    }

    private final void generateBufferInvocation(SkinnyMethodAdapter mv, Class returnType, Class[] parameterTypes, Annotation[][] annotations) {
        int lvarSession;
        boolean sessionRequired = AsmLibraryLoader.isSessionRequired(parameterTypes);
        int n = lvarSession = sessionRequired ? AsmLibraryLoader.getTotalParameterSize(parameterTypes) + 1 : -1;
        if (sessionRequired) {
            mv.newobj(CodegenUtils.p(InvocationSession.class));
            mv.dup();
            mv.invokespecial(CodegenUtils.p(InvocationSession.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
            mv.astore(lvarSession);
        }
        mv.newobj(CodegenUtils.p(HeapInvocationBuffer.class));
        mv.dup2();
        mv.swap();
        mv.invokespecial(CodegenUtils.p(HeapInvocationBuffer.class), "<init>", CodegenUtils.sig(Void.TYPE, Function.class));
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.dup();
            if (AsmLibraryLoader.isSessionRequired(parameterTypes[i])) {
                mv.aload(lvarSession);
                mv.swap();
            }
            lvar = this.loadParameter(mv, parameterTypes[i], lvar);
            int parameterFlags = DefaultInvokerFactory.getParameterFlags(annotations[i]);
            int nativeArrayFlags = DefaultInvokerFactory.getNativeArrayFlags(parameterFlags) | ((parameterFlags & 2) != 0 ? 4 : 0);
            if (parameterTypes[i].isArray() && parameterTypes[i].getComponentType().isPrimitive()) {
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, parameterTypes[i], Integer.TYPE);
                continue;
            }
            if (Pointer.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, Pointer.class, Integer.TYPE);
                continue;
            }
            if (Address.class.isAssignableFrom(parameterTypes[i])) {
                this.marshal(mv, Pointer.class);
                continue;
            }
            if (Enum.class.isAssignableFrom(parameterTypes[i])) {
                this.marshal(mv, Enum.class);
                continue;
            }
            if (Buffer.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, parameterTypes[i], Integer.TYPE);
                continue;
            }
            if (ByReference.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, ByReference.class, Integer.TYPE);
                continue;
            }
            if (StringBuilder.class.isAssignableFrom(parameterTypes[i]) || StringBuffer.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, parameterTypes[i], Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(parameterTypes[i])) {
                this.marshal(mv, CharSequence.class);
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i])) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, Struct.class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i].isArray() && Struct.class.isAssignableFrom(parameterTypes[i].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.marshal(mv, Struct[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i].isArray() && Pointer.class.isAssignableFrom(parameterTypes[i].getComponentType())) {
                mv.pushInt(parameterFlags);
                mv.pushInt(nativeArrayFlags);
                this.sessionmarshal(mv, Pointer[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (parameterTypes[i].isPrimitive() || Number.class.isAssignableFrom(parameterTypes[i])) {
                this.emitInvocationBufferIntParameter(mv, parameterTypes[i]);
                continue;
            }
            throw new IllegalArgumentException("unsupported parameter type " + parameterTypes[i]);
        }
        String invokeMethod = null;
        Class<Number> nativeReturnType = null;
        if (NumberUtil.isPrimitiveInt(returnType) || Void.TYPE == returnType || Byte.class == returnType || Short.class == returnType || Integer.class == returnType) {
            invokeMethod = "invokeInt";
            nativeReturnType = Integer.TYPE;
        } else if (Long.class == returnType || Long.TYPE == returnType) {
            invokeMethod = "invokeLong";
            nativeReturnType = Long.TYPE;
        } else if (NativeLong.class == returnType) {
            invokeMethod = NativeLong.SIZE == 32 ? "invokeInt" : "invokeLong";
            nativeReturnType = NativeLong.SIZE == 32 ? Integer.TYPE : Long.TYPE;
        } else if (Pointer.class == returnType || Address.class == returnType || Struct.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType)) {
            invokeMethod = "invokeAddress";
            nativeReturnType = Long.TYPE;
        } else if (Float.class == returnType || Float.TYPE == returnType) {
            invokeMethod = "invokeFloat";
            nativeReturnType = Float.TYPE;
        } else if (Double.class == returnType || Double.TYPE == returnType) {
            invokeMethod = "invokeDouble";
            nativeReturnType = Double.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported return type " + returnType);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), invokeMethod, CodegenUtils.sig(nativeReturnType, Function.class, HeapInvocationBuffer.class));
        if (sessionRequired) {
            mv.aload(lvarSession);
            mv.invokevirtual(CodegenUtils.p(InvocationSession.class), "finish", "()V");
        }
        this.emitReturn(mv, returnType, nativeReturnType);
    }

    private final void generateFastIntInvocation(SkinnyMethodAdapter mv, Class returnType, Class[] parameterTypes, boolean ignoreErrno) {
        Class<? extends Number> nativeIntType = AsmLibraryLoader.getNativeIntType(returnType, parameterTypes);
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            lvar = this.loadParameter(mv, parameterTypes[i], lvar);
            if (parameterTypes[i].isPrimitive()) {
                this.widen(mv, parameterTypes[i], nativeIntType);
                continue;
            }
            if (!Number.class.isAssignableFrom(parameterTypes[i])) continue;
            this.unboxNumber(mv, parameterTypes[i], nativeIntType);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), AsmLibraryLoader.getFastIntInvokerMethodName(parameterTypes.length, ignoreErrno, nativeIntType), AsmLibraryLoader.getFastIntInvokerSignature(parameterTypes.length, nativeIntType));
        this.emitReturn(mv, returnType, nativeIntType);
    }

    private final void generateFastNumericInvocation(SkinnyMethodAdapter mv, Class returnType, Class[] parameterTypes) {
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            lvar = this.loadParameter(mv, parameterTypes[i], lvar);
            if (!parameterTypes[i].isPrimitive()) {
                this.unboxNumber(mv, returnType, Long.TYPE);
            }
            if (Float.class == parameterTypes[i] || Float.TYPE == parameterTypes[i]) {
                mv.invokestatic(CodegenUtils.p(Float.class), "floatToRawIntBits", "(F)I");
                mv.i2l();
                continue;
            }
            if (Double.class == parameterTypes[i] || Double.TYPE == parameterTypes[i]) {
                mv.invokestatic(CodegenUtils.p(Double.class), "doubleToRawLongBits", "(D)J");
                continue;
            }
            if (!parameterTypes[i].isPrimitive()) continue;
            this.widen(mv, parameterTypes[i], Long.TYPE);
        }
        StringBuilder sb = new StringBuilder("invoke");
        if (parameterTypes.length == 0) {
            sb.append("V");
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                sb.append("N");
            }
        }
        sb.append("rN");
        String invoke = sb.toString();
        sb = new StringBuilder("(").append(CodegenUtils.ci(Function.class));
        for (int i = 0; i < parameterTypes.length; ++i) {
            sb.append("J");
        }
        String sig = sb.append(")J").toString();
        mv.invokevirtual(CodegenUtils.p(Invoker.class), invoke, sig);
        if (Float.class == returnType || Float.TYPE == returnType) {
            mv.l2i();
            mv.invokestatic(CodegenUtils.p(Float.class), "intBitsToFloat", "(I)F");
        } else if (Double.class == returnType || Double.TYPE == returnType) {
            mv.invokestatic(CodegenUtils.p(Double.class), "longBitsToDouble", "(J)D");
        }
        this.emitReturn(mv, returnType, Long.TYPE);
    }

    private final void emitReturn(SkinnyMethodAdapter mv, Class returnType, Class nativeIntType) {
        if (returnType.isPrimitive()) {
            if (Long.TYPE == returnType) {
                this.widen(mv, nativeIntType, returnType);
                mv.lreturn();
            } else if (Float.TYPE == returnType) {
                mv.freturn();
            } else if (Double.TYPE == returnType) {
                mv.dreturn();
            } else if (Void.TYPE == returnType) {
                mv.voidreturn();
            } else {
                this.narrow(mv, nativeIntType, Integer.TYPE);
                mv.ireturn();
            }
        } else {
            this.boxValue(mv, returnType, nativeIntType);
            mv.areturn();
        }
    }

    private final void widen(SkinnyMethodAdapter mv, Class from, Class to) {
        if (Long.TYPE == to && Long.TYPE != from && NumberUtil.isPrimitiveInt(from)) {
            mv.i2l();
        }
    }

    private final void narrow(SkinnyMethodAdapter mv, Class from, Class to) {
        if (Long.TYPE == from && Long.TYPE != to && NumberUtil.isPrimitiveInt(to)) {
            mv.l2i();
        }
    }

    private final int loadParameter(SkinnyMethodAdapter mv, Class parameterType, int lvar) {
        if (!parameterType.isPrimitive()) {
            mv.aload(lvar++);
        } else if (Long.TYPE == parameterType) {
            mv.lload(lvar);
            lvar += 2;
        } else if (Float.TYPE == parameterType) {
            mv.fload(lvar++);
        } else if (Double.TYPE == parameterType) {
            mv.dload(lvar);
            lvar += 2;
        } else {
            mv.iload(lvar++);
        }
        return lvar;
    }

    private static final Class<? extends Number> getNativeIntType(Class returnType, Class[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!AsmLibraryLoader.requiresLong(parameterTypes[i])) continue;
            return Long.TYPE;
        }
        return AsmLibraryLoader.requiresLong(returnType) ? Long.TYPE : Integer.TYPE;
    }

    static final String getFastIntInvokerMethodName(int parameterCount, boolean ignoreErrno, Class nativeParamType) {
        String t;
        StringBuilder sb = new StringBuilder("invoke");
        if (ignoreErrno && Integer.TYPE == nativeParamType) {
            sb.append("NoErrno");
        }
        String string = t = Integer.TYPE == nativeParamType ? "I" : "L";
        if (parameterCount < 1) {
            sb.append("V");
        } else {
            for (int i = 0; i < parameterCount; ++i) {
                sb.append(t);
            }
        }
        return sb.append("r").append(t).toString();
    }

    static final String getFastIntInvokerSignature(int parameterCount, Class nativeIntType) {
        String t = Integer.TYPE == nativeIntType ? "I" : "J";
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(CodegenUtils.ci(Function.class));
        for (int i = 0; i < parameterCount; ++i) {
            sb.append(t);
        }
        sb.append(")").append(t);
        return sb.toString();
    }

    private final void boxStruct(SkinnyMethodAdapter mv, Class returnType) {
        mv.dup2();
        Label nonnull = new Label();
        Label end = new Label();
        mv.lconst_0();
        mv.lcmp();
        mv.ifne(nonnull);
        mv.pop2();
        mv.aconst_null();
        mv.go_to(end);
        mv.label(nonnull);
        mv.newobj(CodegenUtils.p(returnType));
        mv.dup();
        mv.invokespecial(CodegenUtils.p(returnType), "<init>", "()V");
        mv.dup_x2();
        this.invokestatic(mv, MarshalUtil.class, "useMemory", Void.TYPE, Long.TYPE, Struct.class);
        mv.label(end);
    }

    private final void boxPrimitive(SkinnyMethodAdapter mv, Class primitiveType) {
        Class objClass = NumberUtil.getBoxedClass(primitiveType);
        this.invokestatic(mv, objClass, "valueOf", objClass, primitiveType);
    }

    private final void boxNumber(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        Class<Long> primitiveClass = NumberUtil.getPrimitiveClass(type);
        if (Byte.class.isAssignableFrom(type)) {
            if (Byte.TYPE != nativeType) {
                this.narrow(mv, nativeType, Integer.TYPE);
                mv.i2b();
            }
        } else if (Character.class.isAssignableFrom(type)) {
            if (Character.TYPE != nativeType) {
                this.narrow(mv, nativeType, Integer.TYPE);
                mv.i2c();
            }
        } else if (Short.class.isAssignableFrom(type)) {
            if (Short.TYPE != nativeType) {
                this.narrow(mv, nativeType, Integer.TYPE);
                mv.i2s();
            }
        } else if (Integer.class.isAssignableFrom(type)) {
            this.narrow(mv, nativeType, Integer.TYPE);
        } else if (Long.class.isAssignableFrom(type)) {
            this.widen(mv, nativeType, Long.TYPE);
        } else if (NativeLong.class.isAssignableFrom(type)) {
            this.widen(mv, nativeType, Long.TYPE);
            primitiveClass = Long.TYPE;
        } else if (Boolean.class.isAssignableFrom(type)) {
            this.narrow(mv, nativeType, Integer.TYPE);
        } else if (Float.class != type && Double.class != type) {
            throw new IllegalArgumentException("invalid Number subclass");
        }
        this.invokestatic(mv, type, "valueOf", type, primitiveClass);
    }

    private final void boxValue(SkinnyMethodAdapter mv, Class returnType, Class nativeReturnType) {
        if (Boolean.class.isAssignableFrom(returnType)) {
            this.narrow(mv, nativeReturnType, Integer.TYPE);
            this.invokestatic(mv, returnType, "valueOf", returnType, Boolean.TYPE);
        } else if (Pointer.class.isAssignableFrom(returnType)) {
            this.invokestatic(mv, MarshalUtil.class, "returnPointer", Pointer.class, nativeReturnType);
        } else if (Address.class == returnType) {
            this.widen(mv, nativeReturnType, Long.TYPE);
            this.invokestatic(mv, returnType, "valueOf", returnType, Long.TYPE);
        } else if (Struct.class.isAssignableFrom(returnType)) {
            this.widen(mv, nativeReturnType, Long.TYPE);
            this.boxStruct(mv, returnType);
        } else if (Number.class.isAssignableFrom(returnType)) {
            this.boxNumber(mv, returnType, nativeReturnType);
        } else if (String.class == returnType) {
            this.widen(mv, nativeReturnType, Long.TYPE);
            mv.invokestatic(CodegenUtils.p(MarshalUtil.class), "returnString", CodegenUtils.sig(String.class, Long.TYPE));
        } else {
            throw new IllegalArgumentException("cannot box value of type " + nativeReturnType + " to " + returnType);
        }
    }

    private final void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class nativeIntType) {
        String intValueSignature;
        String intValueMethod = Long.TYPE == nativeIntType ? "longValue" : "intValue";
        String string = intValueSignature = Long.TYPE == nativeIntType ? "()J" : "()I";
        if (Byte.class == boxedType || Short.class == boxedType || Integer.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), intValueMethod, intValueSignature);
        } else if (Long.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
        } else if (Float.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
        } else if (Double.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
        } else if (NativeLong.class.isAssignableFrom(boxedType) && Platform.getPlatform().longSize() == 64) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
        } else if (NativeLong.class.isAssignableFrom(boxedType)) {
            mv.invokevirtual(CodegenUtils.p(boxedType), intValueMethod, intValueSignature);
        } else if (Boolean.class.isAssignableFrom(boxedType)) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "booleanValue", "()Z");
            this.widen(mv, Boolean.TYPE, nativeIntType);
        } else {
            throw new IllegalArgumentException("unsupported Number subclass");
        }
    }

    private final void emitReturnOp(SkinnyMethodAdapter mv, Class returnType) {
        if (!returnType.isPrimitive()) {
            mv.areturn();
        } else if (Long.TYPE == returnType) {
            mv.lreturn();
        } else if (Float.TYPE == returnType) {
            mv.freturn();
        } else if (Double.TYPE == returnType) {
            mv.dreturn();
        } else if (Void.TYPE == returnType) {
            mv.voidreturn();
        } else {
            mv.ireturn();
        }
    }

    private final void emitInvocationBufferIntParameter(SkinnyMethodAdapter mv, Class parameterType) {
        String paramMethod = null;
        Class<Number> paramClass = Integer.TYPE;
        if (!parameterType.isPrimitive()) {
            this.unboxNumber(mv, parameterType, null);
        }
        if (Byte.TYPE == parameterType || Byte.class == parameterType) {
            paramMethod = "putByte";
        } else if (Short.TYPE == parameterType || Short.class == parameterType) {
            paramMethod = "putShort";
        } else if (Integer.TYPE == parameterType || Integer.class == parameterType || Boolean.TYPE == parameterType) {
            paramMethod = "putInt";
        } else if (Long.TYPE == parameterType || Long.class == parameterType) {
            paramMethod = "putLong";
            paramClass = Long.TYPE;
        } else if (Float.TYPE == parameterType || Float.class == parameterType) {
            paramMethod = "putFloat";
            paramClass = Float.TYPE;
        } else if (Double.TYPE == parameterType || Double.class == parameterType) {
            paramMethod = "putDouble";
            paramClass = Double.TYPE;
        } else if (NativeLong.class.isAssignableFrom(parameterType) && Platform.getPlatform().longSize() == 32) {
            paramMethod = "putInt";
            paramClass = Integer.TYPE;
        } else if (NativeLong.class.isAssignableFrom(parameterType) && Platform.getPlatform().longSize() == 64) {
            paramMethod = "putLong";
            paramClass = Long.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported parameter type " + parameterType);
        }
        mv.invokevirtual(CodegenUtils.p(HeapInvocationBuffer.class), paramMethod, CodegenUtils.sig(Void.TYPE, paramClass));
    }

    private final void invokestatic(SkinnyMethodAdapter mv, Class recv, String methodName, Class returnType, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(recv), methodName, CodegenUtils.sig(returnType, parameterTypes));
    }

    private final void marshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(MarshalUtil.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationBuffer.class), parameterTypes));
    }

    private final void sessionmarshal(SkinnyMethodAdapter mv, Class ... parameterTypes) {
        mv.invokestatic(CodegenUtils.p(MarshalUtil.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationSession.class) + CodegenUtils.ci(InvocationBuffer.class), parameterTypes));
    }

    private static final Function getFunction(long address, Class returnType, Class[] paramTypes, boolean requiresErrno, CallingConvention convention) {
        Type[] nativeParamTypes = new Type[paramTypes.length];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.getNativeParameterType(paramTypes[i]);
        }
        return new Function(address, InvokerUtil.getNativeReturnType(returnType), nativeParamTypes, convention, requiresErrno);
    }

    private static boolean isSessionRequired(Class parameterType) {
        return StringBuilder.class.isAssignableFrom(parameterType) || StringBuffer.class.isAssignableFrom(parameterType) || ByReference.class.isAssignableFrom(parameterType) || parameterType.isArray() && Pointer.class.isAssignableFrom(parameterType.getComponentType());
    }

    private static boolean isSessionRequired(Class[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!AsmLibraryLoader.isSessionRequired(parameterTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static final int getParameterSize(Class parameterType) {
        return Long.TYPE == parameterType || Double.TYPE == parameterType ? 2 : 1;
    }

    private static final int getTotalParameterSize(Class[] parameterTypes) {
        int size = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            size += AsmLibraryLoader.getParameterSize(parameterTypes[i]);
        }
        return size;
    }

    private static boolean isInteger(Class c) {
        return NumberUtil.isPrimitiveInt(c) || Byte.class.isAssignableFrom(c) || Short.class.isAssignableFrom(c) || Integer.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c);
    }

    static final boolean isFastNumericMethod(Class returnType, Class[] parameterTypes) {
        if (parameterTypes.length > 3) {
            return false;
        }
        if (!AsmLibraryLoader.isFastNumericResult(returnType)) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (AsmLibraryLoader.isFastNumericParam(parameterTypes[i])) continue;
            return false;
        }
        return Platform.getPlatform().getCPU() == Platform.CPU.I386 || Platform.getPlatform().getCPU() == Platform.CPU.X86_64;
    }

    static final boolean isFastIntMethod(Class returnType, Class[] parameterTypes) {
        if (parameterTypes.length > 3) {
            return false;
        }
        if (!AsmLibraryLoader.isFastIntResult(returnType)) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (AsmLibraryLoader.isFastIntParam(parameterTypes[i])) continue;
            return false;
        }
        return Platform.getPlatform().getCPU() == Platform.CPU.I386 || Platform.getPlatform().getCPU() == Platform.CPU.X86_64;
    }

    static final boolean isFastIntResult(Class type) {
        return Void.class.isAssignableFrom(type) || Void.TYPE == type || Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type || Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || NativeLong.class.isAssignableFrom(type) && Platform.getPlatform().longSize() == 32 || Pointer.class.isAssignableFrom(type) && Platform.getPlatform().addressSize() == 32 || Struct.class.isAssignableFrom(type) && Platform.getPlatform().addressSize() == 32 || String.class.isAssignableFrom(type) && Platform.getPlatform().addressSize() == 32;
    }

    static final boolean isFastIntParam(Class type) {
        return Byte.class.isAssignableFrom(type) || Byte.TYPE == type || Short.class.isAssignableFrom(type) || Short.TYPE == type || Integer.class.isAssignableFrom(type) || Integer.TYPE == type || Long.class.isAssignableFrom(type) || Long.TYPE == type || NativeLong.class.isAssignableFrom(type) && Platform.getPlatform().longSize() == 32 || Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type;
    }

    static final boolean isFastNumericResult(Class type) {
        return AsmLibraryLoader.isFastIntResult(type) || Long.class.isAssignableFrom(type) || Long.TYPE == type || NativeLong.class.isAssignableFrom(type) || Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Float.TYPE == type || Float.class == type || Double.TYPE == type || Double.class == type;
    }

    static final boolean isFastNumericParam(Class type) {
        return AsmLibraryLoader.isFastIntParam(type) || Long.class.isAssignableFrom(type) || Long.TYPE == type || NativeLong.class.isAssignableFrom(type) || Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Float.TYPE == type || Float.class == type || Double.TYPE == type || Double.class == type;
    }

    static final boolean isFastNumericAvailable() {
        try {
            Invoker.class.getDeclaredMethod("invokeNNNNNNrN", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final boolean requiresLong(Class type) {
        return Long.class.isAssignableFrom(type) || Long.TYPE == type || NativeLong.class.isAssignableFrom(type) && Platform.getPlatform().longSize() == 64 || Pointer.class.isAssignableFrom(type) && Platform.getPlatform().addressSize() == 64 || Struct.class.isAssignableFrom(type) && Platform.getPlatform().addressSize() == 64;
    }

    static final int marshall(byte[] array) {
        if (array == null) {
            return 1;
        }
        return array[0];
    }

    public static void main(String[] args) {
        HashMap<LibraryOption, 1> options = new HashMap<LibraryOption, 1>();
        options.put(LibraryOption.TypeMapper, new TypeMapper(){

            public FromNativeConverter getFromNativeConverter(Class type) {
                if (Long.class.isAssignableFrom(type)) {
                    return new IntToLong();
                }
                return null;
            }

            public ToNativeConverter getToNativeConverter(Class type) {
                if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
                    return new IntToLong();
                }
                return null;
            }
        });
        TestLib lib = AsmLibraryLoader.getInstance().loadLibrary(new Library("test"), TestLib.class, options);
        Long result = lib.add_int32_t(1L, 2);
        System.err.println("result=" + result);
        System.err.println("adding floats=" + lib.add_float(1.0f, 2.0f));
        System.err.println("adding doubles=" + lib.add_double(1.0, 2.0));
    }

    public static interface TestLib {
        public Long add_int32_t(long var1, int var3);

        public Float add_float(float var1, float var2);

        public Double add_double(Double var1, double var2);

        public byte ptr_ret_int8_t(s8[] var1, int var2);

        public static final class s8
        extends Struct {
            public final Struct.Signed8 s8 = new Struct.Signed8(this);
        }
    }

    public static final class IntToLong
    implements FromNativeConverter,
    ToNativeConverter {
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return ((Number)nativeValue).longValue();
        }

        public Object toNative(Object value, ToNativeContext context) {
            return ((Number)value).intValue();
        }

        public Class nativeType() {
            return Integer.class;
        }
    }

    public static final class FromNativeProxy
    implements FromNativeConverter {
        private final FromNativeConverter converter;
        private final FromNativeContext ctx;

        public FromNativeProxy(FromNativeConverter converter, FromNativeContext ctx) {
            this.converter = converter;
            this.ctx = ctx;
        }

        public Object fromNative(Object value, FromNativeContext unused) {
            return this.converter.fromNative(value, this.ctx);
        }

        public Class nativeType() {
            return this.converter.nativeType();
        }
    }

    public static final class ToNativeProxy
    implements ToNativeConverter {
        private final ToNativeConverter converter;
        private final ToNativeContext ctx;

        public ToNativeProxy(ToNativeConverter converter, ToNativeContext ctx) {
            this.converter = converter;
            this.ctx = ctx;
        }

        public Object toNative(Object value, ToNativeContext unused) {
            return this.converter.toNative(value, this.ctx);
        }

        public Class nativeType() {
            return this.converter.nativeType();
        }
    }

    public static abstract class AbstractNativeInterface {
        public static final Invoker ffi = Invoker.getInstance();
        protected final Library library;

        public AbstractNativeInterface(Library library) {
            this.library = library;
        }

        protected static final HeapInvocationBuffer newInvocationBuffer(Function f) {
            return new HeapInvocationBuffer(f);
        }
    }
}

