/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
extends Number
implements Comparable<Address> {
    public static final int SIZE = Platform.getPlatform().addressSize();
    public static final int SHIFT = SIZE == 32 ? 2 : 3;
    public static final long MASK = SIZE == 32 ? 0xFFFFFFFFL : -1L;
    protected final long address;

    public Address(long address) {
        this.address = address & MASK;
    }

    public Address(Address address) {
        this.address = address.address;
    }

    @Override
    public final int intValue() {
        return (int)this.address;
    }

    @Override
    public final long longValue() {
        return this.address;
    }

    @Override
    public final float floatValue() {
        return this.address;
    }

    @Override
    public final double doubleValue() {
        return this.address;
    }

    public final long nativeAddress() {
        return this.address;
    }

    public final int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof Address && this.address == ((Address)obj).address || obj == null && this.address == 0L;
    }

    public String toString() {
        return this.getClass().getName() + String.format("[address=%x]", this.address);
    }

    @Override
    public final int compareTo(Address other) {
        return this.address < other.address ? -1 : (this.address > other.address ? 1 : 0);
    }

    public final boolean isNull() {
        return this.address == 0L;
    }
}

