/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.FFIProvider;
import com.kenai.jaffl.LibraryOption;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Library {
    private static final Map<String, List<String>> customSearchPaths = new ConcurrentHashMap<String, List<String>>();
    private final String name;

    private Library(String libraryName) {
        this.name = libraryName;
    }

    public static <T> T loadLibrary(String libraryName, Class<T> interfaceClass) {
        Map options = Collections.emptyMap();
        return Library.loadLibrary(libraryName, interfaceClass, options);
    }

    public static <T> T loadLibrary(String libraryName, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return FFIProvider.getProvider().loadLibrary(libraryName, interfaceClass, libraryOptions);
    }

    public static final synchronized void addLibraryPath(String libraryName, File path) {
        List<String> customPaths = customSearchPaths.get(libraryName);
        if (customPaths == null) {
            customPaths = new CopyOnWriteArrayList<String>();
            customSearchPaths.put(libraryName, customPaths);
        }
        customPaths.add(path.getAbsolutePath());
    }

    public static List<String> getLibraryPath(String libraryName) {
        List<String> customPaths = customSearchPaths.get(libraryName);
        if (customPaths != null) {
            return customPaths;
        }
        return Collections.emptyList();
    }

    public static final Library getInstance(String libraryName) {
        return new Library(libraryName);
    }

    public boolean hasFunction(String method) {
        return false;
    }

    public String getName() {
        return this.name;
    }
}

