/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.constantine.platform.Errno;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseHeapFileStat;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibCProvider;
import org.jruby.ext.posix.Linux64HeapFileStat;
import org.jruby.ext.posix.LinuxHeapFileStat;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.LinuxPasswd;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.util.Platform;

final class LinuxPOSIX
extends BaseNativePOSIX {
    private final boolean hasFxstat;
    private final boolean hasLxstat;
    private final boolean hasXstat;
    private final boolean hasFstat;
    private final boolean hasLstat;
    private final boolean hasStat;
    private final int statVersion = Platform.IS_32_BIT ? 3 : 0;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new LinuxPasswd((Pointer)arg) : null;
        }
    };

    LinuxPOSIX(String libraryName, LibCProvider libcProvider, POSIXHandler handler) {
        super(libraryName, libcProvider, handler);
        this.hasFxstat = this.hasMethod("__fxstat64");
        this.hasLxstat = this.hasMethod("__lxstat64");
        this.hasXstat = this.hasMethod("__xstat64");
        this.hasFstat = !this.hasFxstat && this.hasMethod("fstat64");
        this.hasLstat = !this.hasLxstat && this.hasMethod("lstat64");
        this.hasStat = !this.hasXstat && this.hasMethod("stat64");
    }

    public BaseHeapFileStat allocateStat() {
        if (Platform.IS_32_BIT) {
            return new LinuxHeapFileStat(this);
        }
        return new Linux64HeapFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        if (!this.hasFxstat) {
            if (this.hasFstat) {
                return super.fstat(fileDescriptor);
            }
            this.handler.unimplementedError("fstat");
        }
        BaseHeapFileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (((LinuxLibC)this.libc()).__fxstat64(this.statVersion, fd, stat) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    public FileStat lstat(String path) {
        if (!this.hasLxstat) {
            if (this.hasLstat) {
                return super.lstat(path);
            }
            this.handler.unimplementedError("lstat");
        }
        BaseHeapFileStat stat = this.allocateStat();
        if (((LinuxLibC)this.libc()).__lxstat64(this.statVersion, path, (FileStat)stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        if (!this.hasXstat) {
            if (this.hasStat) {
                return super.stat(path);
            }
            this.handler.unimplementedError("stat");
        }
        BaseHeapFileStat stat = this.allocateStat();
        if (((LinuxLibC)this.libc()).__xstat64(this.statVersion, path, (FileStat)stat) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }
}

