/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<T> {
    private Map<T, Vertex<T>> vertices = new HashMap<T, Vertex<T>>();
    private Set<Edge<T>> edges = new HashSet<Edge<T>>();
    private ArrayList inOrderVerticeData = new ArrayList();
    int vertexIDCounter = 0;

    public Collection<Vertex<T>> vertices() {
        return this.vertices.values();
    }

    public Collection<Edge<T>> edges() {
        return this.edges;
    }

    public Iterable<Edge<T>> edgesOfType(Object type) {
        return new EdgeTypeIterable<T>(this.edges, type);
    }

    public Collection<T> allData() {
        return this.vertices.keySet();
    }

    public Collection<T> getInorderData() {
        return this.inOrderVerticeData;
    }

    public void addEdge(T source, T destination, Object type) {
        this.findOrCreateVertexFor(source).addEdgeTo(destination, type);
    }

    public void removeEdge(Edge edge) {
        edge.getSource().removeEdgeTo(edge.getDestination());
    }

    public void removeEdge(T source, T destination) {
        if (this.findVertexFor(source) != null) {
            for (Edge<T> edge : this.findOrCreateVertexFor(source).getOutgoingEdges()) {
                if (edge.getDestination().getData() != destination) continue;
                this.findOrCreateVertexFor(source).removeEdgeTo(edge.getDestination());
                return;
            }
        }
    }

    public Vertex<T> findVertexFor(T data) {
        return this.vertices.get(data);
    }

    public Vertex<T> findOrCreateVertexFor(T data) {
        Vertex<T> vertex = this.vertices.get(data);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex<T>(this, data, this.vertexIDCounter++);
        this.inOrderVerticeData.add(data);
        this.vertices.put(data, vertex);
        return vertex;
    }

    public void removeVertexFor(T data) {
        if (this.findVertexFor(data) != null) {
            Vertex<T> vertex = this.findOrCreateVertexFor(data);
            this.vertices.remove(data);
            this.inOrderVerticeData.remove(data);
            vertex.removeAllEdges();
        }
    }

    public int size() {
        return this.allData().size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<Vertex<T>> verts = new ArrayList<Vertex<T>>(this.vertices.values());
        Collections.sort(verts);
        for (Vertex<T> vertex : verts) {
            buf.append(vertex);
        }
        return buf.toString();
    }
}

