/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jruby.dirgra.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataIterator<T>
implements Iterator<T> {
    private Iterator<Edge<T>> internalIterator;
    private Object type;
    private Edge nextEdge = null;
    private boolean source;
    private boolean negate;

    public DataIterator(Set<Edge<T>> edges, Object type, boolean source, boolean negate) {
        this.internalIterator = edges.iterator();
        this.type = type;
        this.source = source;
        this.negate = negate;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEdge != null) {
            return true;
        }
        while (this.internalIterator.hasNext()) {
            Edge<T> edge = this.internalIterator.next();
            Object edgeType = edge.getType();
            if (this.negate) {
                if ((edgeType == null || edgeType.equals(this.type)) && (edgeType != null || edgeType == this.type)) continue;
                this.nextEdge = edge;
                return true;
            }
            if ((edgeType == null || !edgeType.equals(this.type)) && (edgeType != null || edgeType != this.type)) continue;
            this.nextEdge = edge;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            Edge tmp = this.nextEdge;
            this.nextEdge = null;
            return this.source ? tmp.getSource().getData() : tmp.getDestination().getData();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

