/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.LinuxFileStat;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;

public class LinuxPOSIX
extends BaseNativePOSIX {
    private static int STAT_VERSION = 3;
    private boolean hasFxstat = this.hasMethod("__fxstat");
    private boolean hasLxstat = this.hasMethod("__lxstat");
    private boolean hasXstat = this.hasMethod("__xstat");
    private boolean hasFstat = false;
    private boolean hasLstat = false;
    private boolean hasStat = false;

    public LinuxPOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
        if (!this.hasFxstat) {
            this.hasFstat = this.hasMethod("fstat");
        }
        if (!this.hasLxstat) {
            this.hasLstat = this.hasMethod("lstat");
        }
        if (!this.hasXstat) {
            this.hasStat = this.hasMethod("stat");
        }
    }

    public FileStat allocateStat() {
        return new LinuxFileStat(this);
    }

    public FileStat fstat(FileDescriptor fileDescriptor) {
        if (!this.hasFxstat) {
            if (this.hasFstat) {
                return super.fstat(fileDescriptor);
            }
            this.handler.unimplementedError("fstat");
        }
        FileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if (((LinuxLibC)this.libc).__fxstat(STAT_VERSION, fd, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, "" + fd);
        }
        return stat;
    }

    public FileStat lstat(String path) {
        FileStat stat;
        if (!this.hasLxstat) {
            if (this.hasLstat) {
                return super.lstat(path);
            }
            this.handler.unimplementedError("lstat");
        }
        if (((LinuxLibC)this.libc).__lxstat(STAT_VERSION, path, stat = this.allocateStat()) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public FileStat stat(String path) {
        FileStat stat;
        if (!this.hasXstat) {
            if (this.hasStat) {
                return super.stat(path);
            }
            this.handler.unimplementedError("stat");
        }
        if (((LinuxLibC)this.libc).__xstat(STAT_VERSION, path, stat = this.allocateStat()) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }
}

