/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.info;

import com.profesorfalken.wmi4java.WMI4Java;
import com.profesorfalken.wmi4java.WMIClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jprocesses.info.AbstractProcessesService;
import org.jutils.jprocesses.info.VBScriptHelper;
import org.jutils.jprocesses.model.JProcessesResponse;
import org.jutils.jprocesses.model.ProcessInfo;
import org.jutils.jprocesses.util.ProcessesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowsProcessesService
extends AbstractProcessesService {
    private final Map<String, String> userData = new HashMap<String, String>();
    private final Map<String, String> cpuData = new HashMap<String, String>();
    private static final String LINE_BREAK_REGEX = "\\r?\\n";
    private static final Map<String, String> keyMap;
    private static Map<String, String> processMap;

    WindowsProcessesService() {
    }

    @Override
    protected List<Map<String, String>> parseList(String rawData) {
        String[] dataStringLines;
        ArrayList<Map<String, String>> processesDataList = new ArrayList<Map<String, String>>();
        for (String dataLine : dataStringLines = rawData.split(LINE_BREAK_REGEX)) {
            if (dataLine.trim().length() <= 0) continue;
            this.processLine(dataLine, processesDataList);
        }
        return processesDataList;
    }

    private void processLine(String dataLine, List<Map<String, String>> processesDataList) {
        String[] dataStringInfo;
        if (dataLine.startsWith("Caption")) {
            processMap = new HashMap<String, String>();
            processesDataList.add(processMap);
        }
        if (processMap != null && (dataStringInfo = dataLine.split(":", 2)).length == 2) {
            processMap.put(WindowsProcessesService.normalizeKey(dataStringInfo[0].trim()), WindowsProcessesService.normalizeValue(dataStringInfo[0].trim(), dataStringInfo[1].trim()));
            if ("ProcessId".equals(dataStringInfo[0].trim())) {
                processMap.put("user", this.userData.get(dataStringInfo[1].trim()));
                processMap.put("cpu_usage", this.cpuData.get(dataStringInfo[1].trim()));
            }
            if ("CreationDate".equals(dataStringInfo[0].trim())) {
                processMap.put("start_datetime", ProcessesUtils.parseWindowsDateTimeToFullDate(dataStringInfo[1].trim()));
            }
        }
    }

    @Override
    protected String getProcessesData(String name) {
        if (!this.fastMode) {
            this.fillExtraProcessData();
        }
        if (name != null) {
            return WMI4Java.get().VBSEngine().properties(Arrays.asList("Caption", "ProcessId", "Name", "UserModeTime", "CommandLine", "WorkingSetSize", "CreationDate", "VirtualSize", "Priority")).filters(Collections.singletonList("Name like '%" + name + "%'")).getRawWMIObjectOutput(WMIClass.WIN32_PROCESS);
        }
        return WMI4Java.get().VBSEngine().getRawWMIObjectOutput(WMIClass.WIN32_PROCESS);
    }

    @Override
    protected JProcessesResponse kill(int pid) {
        JProcessesResponse response = new JProcessesResponse();
        if (ProcessesUtils.executeCommandAndGetCode("taskkill", "/PID", String.valueOf(pid), "/F") == 0) {
            response.setSuccess(true);
        }
        return response;
    }

    @Override
    protected JProcessesResponse killGracefully(int pid) {
        JProcessesResponse response = new JProcessesResponse();
        if (ProcessesUtils.executeCommandAndGetCode("taskkill", "/PID", String.valueOf(pid)) == 0) {
            response.setSuccess(true);
        }
        return response;
    }

    private static String normalizeKey(String origKey) {
        return keyMap.get(origKey);
    }

    private static String normalizeValue(String origKey, String origValue) {
        if ("UserModeTime".equals(origKey)) {
            long seconds = Long.parseLong(origValue) * 100L / 1000000L / 1000L;
            return WindowsProcessesService.nomalizeTime(seconds);
        }
        if (("VirtualSize".equals(origKey) || "WorkingSetSize".equals(origKey)) && !origValue.isEmpty()) {
            return String.valueOf(Long.parseLong(origValue) / 1024L);
        }
        if ("CreationDate".equals(origKey)) {
            return ProcessesUtils.parseWindowsDateTimeToSimpleTime(origValue);
        }
        return origValue;
    }

    private static String nomalizeTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void fillExtraProcessData() {
        String perfData = WMI4Java.get().VBSEngine().getRawWMIObjectOutput(WMIClass.WIN32_PERFFORMATTEDDATA_PERFPROC_PROCESS);
        String[] dataStringLines = perfData.split(LINE_BREAK_REGEX);
        String pid = null;
        String cpuUsage = null;
        for (String dataLine : dataStringLines) {
            if (dataLine.trim().length() <= 0) continue;
            if (dataLine.startsWith("Caption")) {
                if (pid == null || cpuUsage == null) continue;
                this.cpuData.put(pid, cpuUsage);
                pid = null;
                cpuUsage = null;
                continue;
            }
            if (pid == null) {
                pid = WindowsProcessesService.checkAndGetDataInLine("IDProcess", dataLine);
            }
            if (cpuUsage != null) continue;
            cpuUsage = WindowsProcessesService.checkAndGetDataInLine("PercentProcessorTime", dataLine);
        }
        String processesData = VBScriptHelper.getProcessesOwner();
        if (processesData != null) {
            for (String dataLine : dataStringLines = processesData.split(LINE_BREAK_REGEX)) {
                String[] dataStringInfo = dataLine.split(":", 2);
                if (dataStringInfo.length != 2) continue;
                this.userData.put(dataStringInfo[0].trim(), dataStringInfo[1].trim());
            }
        }
    }

    private static String checkAndGetDataInLine(String dataName, String dataLine) {
        String[] dataStringInfo;
        if (dataLine.startsWith(dataName) && (dataStringInfo = dataLine.split(":")).length == 2) {
            return dataStringInfo[1].trim();
        }
        return null;
    }

    @Override
    public JProcessesResponse changePriority(int pid, int priority) {
        JProcessesResponse response = new JProcessesResponse();
        String message = VBScriptHelper.changePriority(pid, priority);
        if (message.isEmpty()) {
            response.setSuccess(true);
        } else {
            response.setMessage(message);
        }
        return response;
    }

    @Override
    public ProcessInfo getProcess(int pid) {
        return this.getProcess(pid, false);
    }

    @Override
    public ProcessInfo getProcess(int pid, boolean fastMode) {
        this.fastMode = fastMode;
        List<Map<String, String>> allProcesses = this.parseList(this.getProcessesData(null));
        for (Map<String, String> process : allProcesses) {
            if (!String.valueOf(pid).equals(process.get("pid"))) continue;
            ProcessInfo info = new ProcessInfo();
            info.setPid(process.get("pid"));
            info.setName(process.get("proc_name"));
            info.setTime(process.get("proc_time"));
            info.setCommand(process.get("command"));
            info.setCpuUsage(process.get("cpu_usage"));
            info.setPhysicalMemory(process.get("physical_memory"));
            info.setStartTime(process.get("start_time"));
            info.setUser(process.get("user"));
            info.setVirtualMemory(process.get("virtual_memory"));
            info.setPriority(process.get("priority"));
            return info;
        }
        return null;
    }

    static {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        tmpMap.put("Name", "proc_name");
        tmpMap.put("ProcessId", "pid");
        tmpMap.put("UserModeTime", "proc_time");
        tmpMap.put("Priority", "priority");
        tmpMap.put("VirtualSize", "virtual_memory");
        tmpMap.put("WorkingSetSize", "physical_memory");
        tmpMap.put("CommandLine", "command");
        tmpMap.put("CreationDate", "start_time");
        keyMap = Collections.unmodifiableMap(tmpMap);
    }
}

