/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jutils.jprocesses.info.AbstractProcessesService;
import org.jutils.jprocesses.model.JProcessesResponse;
import org.jutils.jprocesses.model.ProcessInfo;
import org.jutils.jprocesses.util.ProcessesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixProcessesService
extends AbstractProcessesService {
    private static final String PS_COLUMNS = "pid,ruser,vsize,rssize,%cpu,bsdstart,bsdtime,nice,comm,cmd";

    UnixProcessesService() {
    }

    @Override
    protected List<Map<String, String>> parseList(String rawData) {
        String[] dataStringLines;
        ArrayList<Map<String, String>> processesDataList = new ArrayList<Map<String, String>>();
        for (String dataLine : dataStringLines = rawData.split("\\r?\\n")) {
            if (dataLine.trim().startsWith("PID")) continue;
            HashMap<String, String> element = new HashMap<String, String>();
            String[] elements = dataLine.split("\\s+");
            if (elements.length <= 10) continue;
            element.put("pid", elements[1]);
            element.put("user", elements[2]);
            element.put("virtual_memory", elements[3]);
            element.put("physical_memory", elements[4]);
            element.put("cpu_usage", elements[5]);
            element.put("start_time", elements[6]);
            element.put("proc_time", elements[7]);
            element.put("priority", elements[8]);
            element.put("proc_name", elements[9]);
            element.put("command", elements[10]);
            processesDataList.add(element);
        }
        return processesDataList;
    }

    @Override
    protected String getProcessesData(String name) {
        if (name != null) {
            return ProcessesUtils.executeCommand("ps", "o", PS_COLUMNS, "-C", name);
        }
        return ProcessesUtils.executeCommand("ps", "o", PS_COLUMNS, "-e");
    }

    @Override
    protected JProcessesResponse kill(int pid) {
        JProcessesResponse response = new JProcessesResponse();
        if (ProcessesUtils.executeCommandAndGetCode("kill", "-9", String.valueOf(pid)) == 0) {
            response.setSuccess(true);
        }
        return response;
    }

    @Override
    public JProcessesResponse changePriority(int pid, int priority) {
        JProcessesResponse response = new JProcessesResponse();
        if (ProcessesUtils.executeCommandAndGetCode("renice", String.valueOf(priority), "-p", String.valueOf(pid)) == 0) {
            response.setSuccess(true);
        }
        return response;
    }

    @Override
    public ProcessInfo getProcess(int pid) {
        List<Map<String, String>> processList = this.parseList(ProcessesUtils.executeCommand("ps", "o", PS_COLUMNS, "-p", String.valueOf(pid)));
        if (processList != null && !processList.isEmpty()) {
            Map<String, String> processData = processList.get(0);
            ProcessInfo info = new ProcessInfo();
            info.setPid(processData.get("pid"));
            info.setName(processData.get("proc_name"));
            info.setTime(processData.get("proc_time"));
            info.setCommand(processData.get("command"));
            info.setCpuUsage(processData.get("cpu_usage"));
            info.setPhysicalMemory(processData.get("physical_memory"));
            info.setStartTime(processData.get("start_time"));
            info.setUser(processData.get("user"));
            info.setVirtualMemory(processData.get("virtual_memory"));
            info.setPriority(processData.get("priority"));
            return info;
        }
        return null;
    }
}

