/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jutils.jprocesses.info.ProcessesService;
import org.jutils.jprocesses.model.ProcessesInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessesService
implements ProcessesService {
    @Override
    public List<ProcessesInfo> getList() {
        String rawData = this.getProcessesData();
        List<Map<String, String>> mapList = this.parseList(rawData);
        return this.buildInfoFromMap(mapList);
    }

    @Override
    public int killProcess(int pid) {
        return this.kill(pid);
    }

    protected abstract List<Map<String, String>> parseList(String var1);

    protected abstract String getProcessesData();

    protected abstract int kill(int var1);

    private List<ProcessesInfo> buildInfoFromMap(List<Map<String, String>> mapList) {
        ArrayList<ProcessesInfo> infoList = new ArrayList<ProcessesInfo>();
        for (Map<String, String> map : mapList) {
            ProcessesInfo info = new ProcessesInfo();
            info.setPid(map.get("pid"));
            info.setName(map.get("proc_name"));
            info.setTime(map.get("proc_time"));
            infoList.add(info);
        }
        return infoList;
    }
}

