/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="Parameter", namespace="http://www.dmg.org/PMML-4_3")
public class Parameter
extends PMMLObject
implements HasExtensions<Parameter>,
Indexable<String> {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="label")
    private String label;
    @XmlAttribute(name="referencePoint")
    @Added(value=Version.PMML_4_0)
    private Double referencePoint;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private static final Double DEFAULT_REFERENCE_POINT = 0.0;
    private static final long serialVersionUID = 67305482L;

    public Parameter() {
    }

    public Parameter(@Property(value="name") String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Parameter setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Parameter setLabel(@Property(value="label") String label) {
        this.label = label;
        return this;
    }

    public Double getReferencePoint() {
        if (this.referencePoint == null) {
            return DEFAULT_REFERENCE_POINT;
        }
        return this.referencePoint;
    }

    public Parameter setReferencePoint(@Property(value="referencePoint") Double referencePoint) {
        this.referencePoint = referencePoint;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public Parameter addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

