/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.SparseArray;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"indices", "entries"})
@XmlRootElement(name="REAL-SparseArray", namespace="http://www.dmg.org/PMML-4_3")
public class RealSparseArray
extends SparseArray<Double> {
    @XmlAttribute(name="n")
    private Integer n;
    @XmlAttribute(name="defaultValue")
    private Double defaultValue;
    @XmlList
    @XmlElement(name="Indices", namespace="http://www.dmg.org/PMML-4_3", type=Integer.class)
    private List<Integer> indices;
    @XmlList
    @XmlElement(name="REAL-Entries", namespace="http://www.dmg.org/PMML-4_3", type=Double.class)
    private List<Double> entries;
    private static final Double DEFAULT_DEFAULT_VALUE = 0.0;
    private static final long serialVersionUID = 67305482L;

    @Override
    public Integer getN() {
        return this.n;
    }

    public RealSparseArray setN(@Property(value="n") Integer n) {
        this.n = n;
        return this;
    }

    @Override
    public Double getDefaultValue() {
        if (this.defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        }
        return this.defaultValue;
    }

    public RealSparseArray setDefaultValue(@Property(value="defaultValue") Double defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public List<Integer> getIndices() {
        if (this.indices == null) {
            this.indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    @Override
    public List<Double> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Double>();
        }
        return this.entries;
    }

    @Override
    public boolean hasIndices() {
        return this.indices != null && this.indices.size() > 0;
    }

    public RealSparseArray addIndices(Integer ... indices) {
        this.getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    @Override
    public boolean hasEntries() {
        return this.entries != null && this.entries.size() > 0;
    }

    public RealSparseArray addEntries(Double ... entries) {
        this.getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

