
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "neuralInputs",
    "neuralLayers",
    "neuralOutputs",
    "modelVerification"
})
@XmlRootElement(name = "NeuralNetwork", namespace = "http://www.dmg.org/PMML-4_3")
public class NeuralNetwork
    extends Model
    implements HasExtensions<NeuralNetwork>
{

    @XmlAttribute(name = "modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "activationFunction", required = true)
    private NeuralNetwork.ActivationFunction activationFunction;
    @XmlAttribute(name = "normalizationMethod")
    private NeuralNetwork.NormalizationMethod normalizationMethod;
    @XmlAttribute(name = "threshold")
    private Double threshold;
    @XmlAttribute(name = "width")
    private Double width;
    @XmlAttribute(name = "altitude")
    private Double altitude;
    @XmlAttribute(name = "numberOfLayers")
    private Integer numberOfLayers;
    @XmlAttribute(name = "isScorable")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @org.jpmml.model.annotations.Extension
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<org.dmg.pmml.Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_3")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_3")
    private LocalTransformations localTransformations;
    @XmlElement(name = "NeuralInputs", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private NeuralInputs neuralInputs;
    @XmlElement(name = "NeuralLayer", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<NeuralLayer> neuralLayers;
    @XmlElement(name = "NeuralOutputs", namespace = "http://www.dmg.org/PMML-4_3")
    private NeuralOutputs neuralOutputs;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_3")
    private ModelVerification modelVerification;
    private final static Double DEFAULT_THRESHOLD = 0.0D;
    private final static Double DEFAULT_ALTITUDE = 1.0D;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67305482L;

    public NeuralNetwork() {
    }

    public NeuralNetwork(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("activationFunction")
        NeuralNetwork.ActivationFunction activationFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("neuralInputs")
        NeuralInputs neuralInputs,
        @org.jpmml.model.annotations.Property("neuralLayers")
        List<NeuralLayer> neuralLayers) {
        this.miningFunction = miningFunction;
        this.activationFunction = activationFunction;
        this.miningSchema = miningSchema;
        this.neuralInputs = neuralInputs;
        this.neuralLayers = neuralLayers;
    }

    public String getModelName() {
        return modelName;
    }

    public NeuralNetwork setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    public NeuralNetwork setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public NeuralNetwork setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public NeuralNetwork.ActivationFunction getActivationFunction() {
        return activationFunction;
    }

    public NeuralNetwork setActivationFunction(
        @org.jpmml.model.annotations.Property("activationFunction")
        NeuralNetwork.ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    public NeuralNetwork.NormalizationMethod getNormalizationMethod() {
        if (normalizationMethod == null) {
            return NeuralNetwork.NormalizationMethod.NONE;
        } else {
            return normalizationMethod;
        }
    }

    public NeuralNetwork setNormalizationMethod(
        @org.jpmml.model.annotations.Property("normalizationMethod")
        NeuralNetwork.NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    public Double getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public NeuralNetwork setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Double getWidth() {
        return width;
    }

    public NeuralNetwork setWidth(
        @org.jpmml.model.annotations.Property("width")
        Double width) {
        this.width = width;
        return this;
    }

    public Double getAltitude() {
        if (altitude == null) {
            return DEFAULT_ALTITUDE;
        } else {
            return altitude;
        }
    }

    public NeuralNetwork setAltitude(
        @org.jpmml.model.annotations.Property("altitude")
        Double altitude) {
        this.altitude = altitude;
        return this;
    }

    public Integer getNumberOfLayers() {
        return numberOfLayers;
    }

    public NeuralNetwork setNumberOfLayers(
        @org.jpmml.model.annotations.Property("numberOfLayers")
        Integer numberOfLayers) {
        this.numberOfLayers = numberOfLayers;
        return this;
    }

    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    public NeuralNetwork setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    public NeuralNetwork setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    public List<org.dmg.pmml.Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<org.dmg.pmml.Extension>();
        }
        return this.extensions;
    }

    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    public NeuralNetwork setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    public Output getOutput() {
        return output;
    }

    public NeuralNetwork setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    public ModelStats getModelStats() {
        return modelStats;
    }

    public NeuralNetwork setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    public NeuralNetwork setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    public Targets getTargets() {
        return targets;
    }

    public NeuralNetwork setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    public NeuralNetwork setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public NeuralInputs getNeuralInputs() {
        return neuralInputs;
    }

    public NeuralNetwork setNeuralInputs(
        @org.jpmml.model.annotations.Property("neuralInputs")
        NeuralInputs neuralInputs) {
        this.neuralInputs = neuralInputs;
        return this;
    }

    public List<NeuralLayer> getNeuralLayers() {
        if (neuralLayers == null) {
            neuralLayers = new ArrayList<NeuralLayer>();
        }
        return this.neuralLayers;
    }

    public NeuralOutputs getNeuralOutputs() {
        return neuralOutputs;
    }

    public NeuralNetwork setNeuralOutputs(
        @org.jpmml.model.annotations.Property("neuralOutputs")
        NeuralOutputs neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
        return this;
    }

    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    public NeuralNetwork setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public NeuralNetwork addExtensions(org.dmg.pmml.Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasNeuralLayers() {
        return ((this.neuralLayers!= null)&&(this.neuralLayers.size()> 0));
    }

    public NeuralNetwork addNeuralLayers(NeuralLayer... neuralLayers) {
        getNeuralLayers().addAll(Arrays.asList(neuralLayers));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getNeuralInputs());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeuralLayers()) {
                status = PMMLObject.traverse(visitor, getNeuralLayers());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getNeuralOutputs(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ActivationFunction {

        @XmlEnumValue("threshold")
        THRESHOLD("threshold"),
        @XmlEnumValue("logistic")
        LOGISTIC("logistic"),
        @XmlEnumValue("tanh")
        TANH("tanh"),
        @XmlEnumValue("identity")
        IDENTITY("identity"),
        @XmlEnumValue("exponential")
        EXPONENTIAL("exponential"),
        @XmlEnumValue("reciprocal")
        RECIPROCAL("reciprocal"),
        @XmlEnumValue("square")
        SQUARE("square"),
        @XmlEnumValue("Gauss")
        GAUSS("Gauss"),
        @XmlEnumValue("sine")
        SINE("sine"),
        @XmlEnumValue("cosine")
        COSINE("cosine"),
        @XmlEnumValue("Elliott")
        ELLIOTT("Elliott"),
        @XmlEnumValue("arctan")
        ARCTAN("arctan"),
        @XmlEnumValue("rectifier")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
        RECTIFIER("rectifier"),
        @XmlEnumValue("radialBasis")
        RADIAL_BASIS("radialBasis");
        private final String value;

        ActivationFunction(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NeuralNetwork.ActivationFunction fromValue(String v) {
            for (NeuralNetwork.ActivationFunction c: NeuralNetwork.ActivationFunction.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum NormalizationMethod {

        @XmlEnumValue("none")
        NONE("none"),
        @XmlEnumValue("simplemax")
        SIMPLEMAX("simplemax"),
        @XmlEnumValue("softmax")
        SOFTMAX("softmax");
        private final String value;

        NormalizationMethod(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static NeuralNetwork.NormalizationMethod fromValue(String v) {
            for (NeuralNetwork.NormalizationMethod c: NeuralNetwork.NormalizationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
