
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "pCovCells"
})
@XmlRootElement(name = "PCovMatrix", namespace = "http://www.dmg.org/PMML-4_3")
public class PCovMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PCovMatrix>
{

    @XmlAttribute(name = "type")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    private PCovMatrix.Type type;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "PCovCell", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<PCovCell> pCovCells;
    private final static long serialVersionUID = 67305482L;

    public PCovMatrix() {
    }

    public PCovMatrix(
        @org.jpmml.model.annotations.Property("pCovCells")
        List<PCovCell> pCovCells) {
        this.pCovCells = pCovCells;
    }

    public PCovMatrix.Type getType() {
        return type;
    }

    public PCovMatrix setType(
        @org.jpmml.model.annotations.Property("type")
        PCovMatrix.Type type) {
        this.type = type;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<PCovCell> getPCovCells() {
        if (pCovCells == null) {
            pCovCells = new ArrayList<PCovCell>();
        }
        return this.pCovCells;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public PCovMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPCovCells() {
        return ((this.pCovCells!= null)&&(this.pCovCells.size()> 0));
    }

    public PCovMatrix addPCovCells(PCovCell... pCovCells) {
        getPCovCells().addAll(Arrays.asList(pCovCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPCovCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPCovCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type {

        @XmlEnumValue("model")
        MODEL("model"),
        @XmlEnumValue("robust")
        ROBUST("robust");
        private final String value;

        Type(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static PCovMatrix.Type fromValue(String v) {
            for (PCovMatrix.Type c: PCovMatrix.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
