
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "KohonenMap", namespace = "http://www.dmg.org/PMML-4_3")
public class KohonenMap
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<KohonenMap>
{

    @XmlAttribute(name = "coord1")
    private Double coord1;
    @XmlAttribute(name = "coord2")
    private Double coord2;
    @XmlAttribute(name = "coord3")
    private Double coord3;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305482L;

    public Double getCoord1() {
        return coord1;
    }

    public KohonenMap setCoord1(
        @Property("coord1")
        Double coord1) {
        this.coord1 = coord1;
        return this;
    }

    public Double getCoord2() {
        return coord2;
    }

    public KohonenMap setCoord2(
        @Property("coord2")
        Double coord2) {
        this.coord2 = coord2;
        return this;
    }

    public Double getCoord3() {
        return coord3;
    }

    public KohonenMap setCoord3(
        @Property("coord3")
        Double coord3) {
        this.coord3 = coord3;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public KohonenMap addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
