
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasId;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_3")
public class Item
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Item> , HasFieldReference<Item> , HasId<Item> , Indexable<String>
{

    @XmlAttribute(name = "id", required = true)
    private String id;
    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    private FieldName field;
    @XmlAttribute(name = "category")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    private String category;
    @XmlAttribute(name = "mappedValue")
    private String mappedValue;
    @XmlAttribute(name = "weight")
    private Double weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305482L;

    public Item() {
    }

    public Item(
        @org.jpmml.model.annotations.Property("id")
        String id,
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.id = id;
        this.value = value;
    }

    public String getId() {
        return id;
    }

    public Item setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Item setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public FieldName getField() {
        return field;
    }

    public Item setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public String getCategory() {
        return category;
    }

    public Item setCategory(
        @org.jpmml.model.annotations.Property("category")
        String category) {
        this.category = category;
        return this;
    }

    public String getMappedValue() {
        return mappedValue;
    }

    public Item setMappedValue(
        @org.jpmml.model.annotations.Property("mappedValue")
        String mappedValue) {
        this.mappedValue = mappedValue;
        return this;
    }

    public Double getWeight() {
        return weight;
    }

    public Item setWeight(
        @org.jpmml.model.annotations.Property("weight")
        Double weight) {
        this.weight = weight;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return getId();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Item addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
