
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "defineFunctions",
    "derivedFields"
})
@XmlRootElement(name = "TransformationDictionary", namespace = "http://www.dmg.org/PMML-4_3")
public class TransformationDictionary
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<TransformationDictionary>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "DefineFunction", namespace = "http://www.dmg.org/PMML-4_3")
    private List<DefineFunction> defineFunctions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_3")
    private List<DerivedField> derivedFields;
    private final static long serialVersionUID = 67305482L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<DefineFunction> getDefineFunctions() {
        if (defineFunctions == null) {
            defineFunctions = new ArrayList<DefineFunction>();
        }
        return this.defineFunctions;
    }

    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<DerivedField>();
        }
        return this.derivedFields;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TransformationDictionary addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDefineFunctions() {
        return ((this.defineFunctions!= null)&&(this.defineFunctions.size()> 0));
    }

    public TransformationDictionary addDefineFunctions(DefineFunction... defineFunctions) {
        getDefineFunctions().addAll(Arrays.asList(defineFunctions));
        return this;
    }

    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(this.derivedFields.size()> 0));
    }

    public TransformationDictionary addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDefineFunctions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDefineFunctions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
