
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "textIndexNormalizations",
    "expression"
})
@XmlRootElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_2))
public class TextIndex
    extends org.dmg.pmml.Expression
    implements HasExpression<TextIndex> , HasExtensions<TextIndex> , HasFieldReference<TextIndex>
{

    @XmlAttribute(name = "textField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private org.dmg.pmml.FieldName textField;
    @XmlAttribute(name = "localTermWeights")
    private TextIndex.LocalTermWeights localTermWeights;
    @XmlAttribute(name = "isCaseSensitive")
    private Boolean caseSensitive;
    @XmlAttribute(name = "maxLevenshteinDistance")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name = "countHits")
    private TextIndex.CountHits countHits;
    @XmlAttribute(name = "wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name = "tokenize")
    private Boolean tokenize;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TextIndexNormalization", namespace = "http://www.dmg.org/PMML-4_3")
    private List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_3", type = Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_3", type = FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_3", type = NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_3", type = NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_3", type = Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_3", type = MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_3", type = TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_3", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_3", type = Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_3", type = Lag.class)
    })
    private org.dmg.pmml.Expression expression;
    private final static Boolean DEFAULT_CASE_SENSITIVE = false;
    private final static Integer DEFAULT_MAX_LEVENSHTEIN_DISTANCE = 0;
    private final static Boolean DEFAULT_TOKENIZE = true;
    private final static long serialVersionUID = 67305482L;

    public TextIndex() {
    }

    public TextIndex(
        @org.jpmml.model.annotations.Property("textField")
        org.dmg.pmml.FieldName textField) {
        this.textField = textField;
    }

    public org.dmg.pmml.FieldName getTextField() {
        return textField;
    }

    public TextIndex setTextField(
        @org.jpmml.model.annotations.Property("textField")
        org.dmg.pmml.FieldName textField) {
        this.textField = textField;
        return this;
    }

    public TextIndex.LocalTermWeights getLocalTermWeights() {
        if (localTermWeights == null) {
            return TextIndex.LocalTermWeights.TERM_FREQUENCY;
        } else {
            return localTermWeights;
        }
    }

    public TextIndex setLocalTermWeights(
        @org.jpmml.model.annotations.Property("localTermWeights")
        TextIndex.LocalTermWeights localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public boolean isCaseSensitive() {
        if (caseSensitive == null) {
            return DEFAULT_CASE_SENSITIVE;
        } else {
            return caseSensitive;
        }
    }

    public TextIndex setCaseSensitive(
        @org.jpmml.model.annotations.Property("caseSensitive")
        Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Integer getMaxLevenshteinDistance() {
        if (maxLevenshteinDistance == null) {
            return DEFAULT_MAX_LEVENSHTEIN_DISTANCE;
        } else {
            return maxLevenshteinDistance;
        }
    }

    public TextIndex setMaxLevenshteinDistance(
        @org.jpmml.model.annotations.Property("maxLevenshteinDistance")
        Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    public TextIndex.CountHits getCountHits() {
        if (countHits == null) {
            return TextIndex.CountHits.ALL_HITS;
        } else {
            return countHits;
        }
    }

    public TextIndex setCountHits(
        @org.jpmml.model.annotations.Property("countHits")
        TextIndex.CountHits countHits) {
        this.countHits = countHits;
        return this;
    }

    public String getWordSeparatorCharacterRE() {
        if (wordSeparatorCharacterRE == null) {
            return "\\s";
        } else {
            return wordSeparatorCharacterRE;
        }
    }

    public TextIndex setWordSeparatorCharacterRE(
        @org.jpmml.model.annotations.Property("wordSeparatorCharacterRE")
        String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    public boolean isTokenize() {
        if (tokenize == null) {
            return DEFAULT_TOKENIZE;
        } else {
            return tokenize;
        }
    }

    public TextIndex setTokenize(
        @org.jpmml.model.annotations.Property("tokenize")
        Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (textIndexNormalizations == null) {
            textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    public org.dmg.pmml.Expression getExpression() {
        return expression;
    }

    public TextIndex setExpression(
        @org.jpmml.model.annotations.Property("expression")
        org.dmg.pmml.Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public org.dmg.pmml.FieldName getField() {
        return getTextField();
    }

    @Override
    public TextIndex setField(org.dmg.pmml.FieldName field) {
        return setTextField(field);
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TextIndex addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextIndexNormalizations() {
        return ((this.textIndexNormalizations!= null)&&(this.textIndexNormalizations.size()> 0));
    }

    public TextIndex addTextIndexNormalizations(TextIndexNormalization... textIndexNormalizations) {
        getTextIndexNormalizations().addAll(Arrays.asList(textIndexNormalizations));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTextIndexNormalizations()) {
                status = PMMLObject.traverse(visitor, getTextIndexNormalizations());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getExpression());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum CountHits {

        @XmlEnumValue("allHits")
        ALL_HITS("allHits"),
        @XmlEnumValue("bestHits")
        BEST_HITS("bestHits");
        private final String value;

        CountHits(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextIndex.CountHits fromValue(String v) {
            for (TextIndex.CountHits c: TextIndex.CountHits.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum LocalTermWeights {

        @XmlEnumValue("termFrequency")
        TERM_FREQUENCY("termFrequency"),
        @XmlEnumValue("binary")
        BINARY("binary"),
        @XmlEnumValue("logarithmic")
        LOGARITHMIC("logarithmic"),
        @XmlEnumValue("augmentedNormalizedTermFrequency")
        AUGMENTED_NORMALIZED_TERM_FREQUENCY("augmentedNormalizedTermFrequency");
        private final String value;

        LocalTermWeights(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static TextIndex.LocalTermWeights fromValue(String v) {
            for (TextIndex.LocalTermWeights c: TextIndex.LocalTermWeights.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
