
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "array"
})
@XmlRootElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3")
public class SimpleSetPredicate
    extends Predicate
    implements HasExtensions<SimpleSetPredicate> , HasFieldReference<SimpleSetPredicate> , HasValueSet<SimpleSetPredicate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "booleanOperator", required = true)
    private SimpleSetPredicate.BooleanOperator booleanOperator;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private Array array;
    private final static long serialVersionUID = 67305482L;

    public SimpleSetPredicate() {
    }

    public SimpleSetPredicate(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("booleanOperator")
        SimpleSetPredicate.BooleanOperator booleanOperator,
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.field = field;
        this.booleanOperator = booleanOperator;
        this.array = array;
    }

    public FieldName getField() {
        return field;
    }

    public SimpleSetPredicate setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public SimpleSetPredicate.BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    public SimpleSetPredicate setBooleanOperator(
        @org.jpmml.model.annotations.Property("booleanOperator")
        SimpleSetPredicate.BooleanOperator booleanOperator) {
        this.booleanOperator = booleanOperator;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Array getArray() {
        return array;
    }

    public SimpleSetPredicate setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SimpleSetPredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum BooleanOperator {

        @XmlEnumValue("isIn")
        IS_IN("isIn"),
        @XmlEnumValue("isNotIn")
        IS_NOT_IN("isNotIn");
        private final String value;

        BooleanOperator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SimpleSetPredicate.BooleanOperator fromValue(String v) {
            for (SimpleSetPredicate.BooleanOperator c: SimpleSetPredicate.BooleanOperator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
