
package org.dmg.pmml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.annotations.Added;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "ParameterField", namespace = "http://www.dmg.org/PMML-4_3")
public class ParameterField
    extends Field<ParameterField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name = "optype")
    private OpType opType;
    @XmlAttribute(name = "dataType")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    private DataType dataType;
    private final static long serialVersionUID = 67305482L;

    public ParameterField() {
    }

    public ParameterField(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
    }

    public FieldName getName() {
        return name;
    }

    public ParameterField setName(
        @org.jpmml.model.annotations.Property("name")
        FieldName name) {
        this.name = name;
        return this;
    }

    public OpType getOpType() {
        return opType;
    }

    public ParameterField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    public DataType getDataType() {
        return dataType;
    }

    public ParameterField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
