
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "outputFields"
})
@XmlRootElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_3")
public class Output
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Output>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "OutputField", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<OutputField> outputFields;
    private final static long serialVersionUID = 67305482L;

    public Output() {
    }

    public Output(
        @Property("outputFields")
        List<OutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<OutputField> getOutputFields() {
        if (outputFields == null) {
            outputFields = new ArrayList<OutputField>();
        }
        return this.outputFields;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Output addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasOutputFields() {
        return ((this.outputFields!= null)&&(this.outputFields.size()> 0));
    }

    public Output addOutputFields(OutputField... outputFields) {
        getOutputFields().addAll(Arrays.asList(outputFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasOutputFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getOutputFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
