
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "content"
})
@XmlRootElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
public class Extension
    extends org.dmg.pmml.PMMLObject
{

    @XmlAttribute(name = "extender")
    private String extender;
    @XmlAttribute(name = "name")
    private String name;
    @XmlAttribute(name = "value")
    private String value;
    @XmlMixed
    @XmlAnyElement(lax = true)
    private List<Object> content;
    private final static long serialVersionUID = 67305482L;

    public String getExtender() {
        return extender;
    }

    public Extension setExtender(
        @Property("extender")
        String extender) {
        this.extender = extender;
        return this;
    }

    public String getName() {
        return name;
    }

    public Extension setName(
        @Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Extension setValue(
        @Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(this.content.size()> 0));
    }

    public Extension addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
