/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.adapters;

import java.math.BigDecimal;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.adapters.ValueUtil;

public class DecimalAdapter
extends XmlAdapter<String, Double> {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    protected static final BigDecimal MIN_VALUE = BigDecimal.valueOf(-1.7976931348623157E308);
    protected static final BigDecimal MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);

    public Double unmarshal(String value) {
        if ("0.0".equals(value)) {
            return ZERO;
        }
        if ("1.0".equals(value)) {
            return ONE;
        }
        BigDecimal decimal = DatatypeConverter.parseDecimal((String)value);
        if (!ValueUtil.checkRange(decimal, MIN_VALUE, MAX_VALUE)) {
            throw new IllegalArgumentException(value);
        }
        return decimal.doubleValue();
    }

    public String marshal(Double value) {
        if (value == null) {
            return null;
        }
        return DatatypeConverter.printDecimal((BigDecimal)BigDecimal.valueOf(value));
    }
}

