/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Kernel;
import org.dmg.pmml.LinearKernel;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PolynomialKernel;
import org.dmg.pmml.RadialBasisKernel;
import org.dmg.pmml.SigmoidKernel;
import org.dmg.pmml.SupportVectorMachine;
import org.dmg.pmml.SvmClassificationMethodType;
import org.dmg.pmml.SvmRepresentationType;
import org.dmg.pmml.Targets;
import org.dmg.pmml.VectorDictionary;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "kernel", "vectorDictionary", "supportVectorMachines", "modelVerification"})
@XmlRootElement(name="SupportVectorMachineModel", namespace="http://www.dmg.org/PMML-4_2")
public class SupportVectorMachineModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="threshold")
    @Added(value=Version.PMML_4_0)
    private Double threshold;
    @XmlAttribute(name="svmRepresentation")
    private SvmRepresentationType svmRepresentation;
    @XmlAttribute(name="alternateBinaryTargetCategory")
    @Added(value=Version.PMML_3_1)
    @Removed(value=Version.PMML_4_0)
    private String alternateBinaryTargetCategory;
    @XmlAttribute(name="classificationMethod")
    @Added(value=Version.PMML_4_0)
    private SvmClassificationMethodType classificationMethod;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElements(value={@XmlElement(name="LinearKernelType", namespace="http://www.dmg.org/PMML-4_2", type=LinearKernel.class), @XmlElement(name="PolynomialKernelType", namespace="http://www.dmg.org/PMML-4_2", type=PolynomialKernel.class), @XmlElement(name="RadialBasisKernelType", namespace="http://www.dmg.org/PMML-4_2", type=RadialBasisKernel.class), @XmlElement(name="SigmoidKernelType", namespace="http://www.dmg.org/PMML-4_2", type=SigmoidKernel.class)})
    private Kernel kernel;
    @XmlElement(name="VectorDictionary", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private VectorDictionary vectorDictionary;
    @XmlElement(name="SupportVectorMachine", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public SupportVectorMachineModel() {
    }

    public SupportVectorMachineModel(MiningFunctionType functionName, MiningSchema miningSchema, VectorDictionary vectorDictionary, List<SupportVectorMachine> supportVectorMachines) {
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public SupportVectorMachineModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public SupportVectorMachineModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public SupportVectorMachineModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public double getThreshold() {
        if (this.threshold == null) {
            return 0.0;
        }
        return this.threshold;
    }

    public SupportVectorMachineModel setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public SvmRepresentationType getSvmRepresentation() {
        if (this.svmRepresentation == null) {
            return SvmRepresentationType.SUPPORT_VECTORS;
        }
        return this.svmRepresentation;
    }

    public SupportVectorMachineModel setSvmRepresentation(SvmRepresentationType svmRepresentation) {
        this.svmRepresentation = svmRepresentation;
        return this;
    }

    public String getAlternateBinaryTargetCategory() {
        return this.alternateBinaryTargetCategory;
    }

    public SupportVectorMachineModel setAlternateBinaryTargetCategory(String alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    public SvmClassificationMethodType getClassificationMethod() {
        if (this.classificationMethod == null) {
            return SvmClassificationMethodType.ONE_AGAINST_ALL;
        }
        return this.classificationMethod;
    }

    public SupportVectorMachineModel setClassificationMethod(SvmClassificationMethodType classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    @Override
    public SupportVectorMachineModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public SupportVectorMachineModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public SupportVectorMachineModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public SupportVectorMachineModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public SupportVectorMachineModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public SupportVectorMachineModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public SupportVectorMachineModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public SupportVectorMachineModel setKernel(Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    public VectorDictionary getVectorDictionary() {
        return this.vectorDictionary;
    }

    public SupportVectorMachineModel setVectorDictionary(VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (this.supportVectorMachines == null) {
            this.supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public SupportVectorMachineModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public SupportVectorMachineModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return this.supportVectorMachines != null && this.supportVectorMachines.size() > 0;
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine ... supportVectorMachines) {
        this.getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getKernel(), this.getVectorDictionary());
        }
        if (status == VisitorAction.CONTINUE && this.hasSupportVectorMachines()) {
            status = PMMLObject.traverse(visitor, this.getSupportVectorMachines());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getModelVerification());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

