/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VerificationFields;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "verificationFields", "inlineTable"})
@XmlRootElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
public class ModelVerification
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="recordCount")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer recordCount;
    @XmlAttribute(name="fieldCount")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer fieldCount;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="VerificationFields", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private VerificationFields verificationFields;
    @XmlElement(name="InlineTable", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private InlineTable inlineTable;

    public ModelVerification() {
    }

    public ModelVerification(VerificationFields verificationFields, InlineTable inlineTable) {
        this.verificationFields = verificationFields;
        this.inlineTable = inlineTable;
    }

    public Integer getRecordCount() {
        return this.recordCount;
    }

    public ModelVerification setRecordCount(Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return this.fieldCount;
    }

    public ModelVerification setFieldCount(Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public VerificationFields getVerificationFields() {
        return this.verificationFields;
    }

    public ModelVerification setVerificationFields(VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
        return this;
    }

    public InlineTable getInlineTable() {
        return this.inlineTable;
    }

    public ModelVerification setInlineTable(InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public ModelVerification addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getVerificationFields(), this.getInlineTable());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

