/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public final class FieldName
implements Serializable {
    private String value = null;
    private static final Map<String, WeakReference<FieldName>> cache = new WeakHashMap<String, WeakReference<FieldName>>();

    public FieldName(String value) {
        this.setValue(value);
    }

    public boolean isInterned() {
        FieldName cachedName;
        WeakReference<FieldName> reference = cache.get(this.getValue());
        if (reference != null && (cachedName = (FieldName)reference.get()) != null) {
            return cachedName == this;
        }
        return false;
    }

    public FieldName intern() {
        return FieldName.create(this.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FieldName) {
            FieldName that = (FieldName)object;
            return this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    Object readResolve() {
        return this.intern();
    }

    public static FieldName create(String value) {
        FieldName cachedName;
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException();
        }
        WeakReference<FieldName> reference = cache.get(value);
        if (reference != null && (cachedName = (FieldName)reference.get()) != null) {
            return cachedName;
        }
        FieldName name = new FieldName(value);
        cache.put(value, new WeakReference<FieldName>(name));
        return name;
    }
}

