/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.ClassLabels;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "classLabels", "matrix"})
@XmlRootElement(name="ConfusionMatrix", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_0)
public class ConfusionMatrix
extends PMMLObject
implements HasExtensions {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="ClassLabels", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private ClassLabels classLabels;
    @XmlElement(name="Matrix", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private Matrix matrix;

    public ConfusionMatrix() {
    }

    public ConfusionMatrix(ClassLabels classLabels, Matrix matrix) {
        this.classLabels = classLabels;
        this.matrix = matrix;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public ClassLabels getClassLabels() {
        return this.classLabels;
    }

    public ConfusionMatrix setClassLabels(ClassLabels classLabels) {
        this.classLabels = classLabels;
        return this;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public ConfusionMatrix setMatrix(Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public ConfusionMatrix addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getClassLabels(), this.getMatrix());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

