/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasId;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.DecimalAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="AssociationRule", namespace="http://www.dmg.org/PMML-4_2")
public class AssociationRule
extends Entity
implements HasExtensions,
HasId {
    @XmlAttribute(name="antecedent", required=true)
    private String antecedent;
    @XmlAttribute(name="consequent", required=true)
    private String consequent;
    @XmlAttribute(name="support", required=true)
    @XmlJavaTypeAdapter(value=DecimalAdapter.class)
    private Double support;
    @XmlAttribute(name="confidence", required=true)
    @XmlJavaTypeAdapter(value=DecimalAdapter.class)
    private Double confidence;
    @XmlAttribute(name="lift")
    private Double lift;
    @XmlAttribute(name="leverage")
    @Added(value=Version.PMML_4_1)
    private Double leverage;
    @XmlAttribute(name="affinity")
    @XmlJavaTypeAdapter(value=DecimalAdapter.class)
    @Added(value=Version.PMML_4_1)
    private Double affinity;
    @XmlAttribute(name="id")
    private String id;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public AssociationRule() {
    }

    public AssociationRule(String antecedent, String consequent, Double support, Double confidence) {
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    public String getAntecedent() {
        return this.antecedent;
    }

    public AssociationRule setAntecedent(String antecedent) {
        this.antecedent = antecedent;
        return this;
    }

    public String getConsequent() {
        return this.consequent;
    }

    public AssociationRule setConsequent(String consequent) {
        this.consequent = consequent;
        return this;
    }

    public Double getSupport() {
        return this.support;
    }

    public AssociationRule setSupport(Double support) {
        this.support = support;
        return this;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public AssociationRule setConfidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    public Double getLift() {
        return this.lift;
    }

    public AssociationRule setLift(Double lift) {
        this.lift = lift;
        return this;
    }

    public Double getLeverage() {
        return this.leverage;
    }

    public AssociationRule setLeverage(Double leverage) {
        this.leverage = leverage;
        return this;
    }

    public Double getAffinity() {
        return this.affinity;
    }

    public AssociationRule setAffinity(Double affinity) {
        this.affinity = affinity;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AssociationRule setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public AssociationRule addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

