/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "textIndexNormalizations", "expression"})
@XmlRootElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_2)
public class TextIndex
extends Expression
implements HasExtensions {
    @XmlAttribute(name="textField", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName textField;
    @XmlAttribute(name="localTermWeights")
    private String localTermWeights;
    @XmlAttribute(name="isCaseSensitive")
    private Boolean isCaseSensitive;
    @XmlAttribute(name="maxLevenshteinDistance")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @XmlSchemaType(name="integer")
    private Integer maxLevenshteinDistance;
    @XmlAttribute(name="countHits")
    private String countHits;
    @XmlAttribute(name="wordSeparatorCharacterRE")
    private String wordSeparatorCharacterRE;
    @XmlAttribute(name="tokenize")
    private Boolean tokenize;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="TextIndexNormalization", namespace="http://www.dmg.org/PMML-4_2")
    private List<TextIndexNormalization> textIndexNormalizations;
    @XmlElements(value={@XmlElement(name="Constant", namespace="http://www.dmg.org/PMML-4_2", type=Constant.class), @XmlElement(name="FieldRef", namespace="http://www.dmg.org/PMML-4_2", type=FieldRef.class), @XmlElement(name="NormContinuous", namespace="http://www.dmg.org/PMML-4_2", type=NormContinuous.class), @XmlElement(name="NormDiscrete", namespace="http://www.dmg.org/PMML-4_2", type=NormDiscrete.class), @XmlElement(name="Discretize", namespace="http://www.dmg.org/PMML-4_2", type=Discretize.class), @XmlElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_2", type=MapValues.class), @XmlElement(name="TextIndex", namespace="http://www.dmg.org/PMML-4_2", type=TextIndex.class), @XmlElement(name="Apply", namespace="http://www.dmg.org/PMML-4_2", type=Apply.class), @XmlElement(name="Aggregate", namespace="http://www.dmg.org/PMML-4_2", type=Aggregate.class)})
    private Expression expression;

    public TextIndex() {
    }

    public TextIndex(FieldName textField) {
        this.textField = textField;
    }

    public FieldName getTextField() {
        return this.textField;
    }

    public TextIndex setTextField(FieldName textField) {
        this.textField = textField;
        return this;
    }

    public String getLocalTermWeights() {
        if (this.localTermWeights == null) {
            return "termFrequency";
        }
        return this.localTermWeights;
    }

    public TextIndex setLocalTermWeights(String localTermWeights) {
        this.localTermWeights = localTermWeights;
        return this;
    }

    public boolean isIsCaseSensitive() {
        if (this.isCaseSensitive == null) {
            return false;
        }
        return this.isCaseSensitive;
    }

    public TextIndex setIsCaseSensitive(Boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        return this;
    }

    public int getMaxLevenshteinDistance() {
        if (this.maxLevenshteinDistance == null) {
            return new IntegerAdapter().unmarshal("0");
        }
        return this.maxLevenshteinDistance;
    }

    public TextIndex setMaxLevenshteinDistance(Integer maxLevenshteinDistance) {
        this.maxLevenshteinDistance = maxLevenshteinDistance;
        return this;
    }

    public String getCountHits() {
        if (this.countHits == null) {
            return "allHits";
        }
        return this.countHits;
    }

    public TextIndex setCountHits(String countHits) {
        this.countHits = countHits;
        return this;
    }

    public String getWordSeparatorCharacterRE() {
        if (this.wordSeparatorCharacterRE == null) {
            return "\\s";
        }
        return this.wordSeparatorCharacterRE;
    }

    public TextIndex setWordSeparatorCharacterRE(String wordSeparatorCharacterRE) {
        this.wordSeparatorCharacterRE = wordSeparatorCharacterRE;
        return this;
    }

    public boolean isTokenize() {
        if (this.tokenize == null) {
            return true;
        }
        return this.tokenize;
    }

    public TextIndex setTokenize(Boolean tokenize) {
        this.tokenize = tokenize;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TextIndexNormalization> getTextIndexNormalizations() {
        if (this.textIndexNormalizations == null) {
            this.textIndexNormalizations = new ArrayList<TextIndexNormalization>();
        }
        return this.textIndexNormalizations;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public TextIndex setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public TextIndex addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextIndexNormalizations() {
        return this.textIndexNormalizations != null && this.textIndexNormalizations.size() > 0;
    }

    public TextIndex addTextIndexNormalizations(TextIndexNormalization ... textIndexNormalizations) {
        this.getTextIndexNormalizations().addAll(Arrays.asList(textIndexNormalizations));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE && this.hasTextIndexNormalizations()) {
            status = PMMLObject.traverse(visitor, this.getTextIndexNormalizations());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getExpression());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

