/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RegressionNormalizationMethodType;
import org.dmg.pmml.RegressionTable;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Deprecated;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "regressionTables", "modelVerification"})
@XmlRootElement(name="RegressionModel", namespace="http://www.dmg.org/PMML-4_2")
public class RegressionModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="modelType")
    @Deprecated(value=Version.PMML_3_0)
    private ModelType modelType;
    @XmlAttribute(name="targetFieldName")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @Deprecated(value=Version.PMML_3_0)
    private FieldName targetFieldName;
    @XmlAttribute(name="normalizationMethod")
    private RegressionNormalizationMethodType normalizationMethod;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_2")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="RegressionTable", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<RegressionTable> regressionTables;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public RegressionModel() {
    }

    public RegressionModel(MiningFunctionType functionName, MiningSchema miningSchema, List<RegressionTable> regressionTables) {
        this.functionName = functionName;
        this.miningSchema = miningSchema;
        this.regressionTables = regressionTables;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public RegressionModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public RegressionModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public RegressionModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public RegressionModel setModelType(ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public FieldName getTargetFieldName() {
        return this.targetFieldName;
    }

    public RegressionModel setTargetFieldName(FieldName targetFieldName) {
        this.targetFieldName = targetFieldName;
        return this;
    }

    public RegressionNormalizationMethodType getNormalizationMethod() {
        if (this.normalizationMethod == null) {
            return RegressionNormalizationMethodType.NONE;
        }
        return this.normalizationMethod;
    }

    public RegressionModel setNormalizationMethod(RegressionNormalizationMethodType normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    @Override
    public RegressionModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public RegressionModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public RegressionModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public RegressionModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public RegressionModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public RegressionModel setTargets(Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public RegressionModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public List<RegressionTable> getRegressionTables() {
        if (this.regressionTables == null) {
            this.regressionTables = new ArrayList<RegressionTable>();
        }
        return this.regressionTables;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public RegressionModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public RegressionModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasRegressionTables() {
        return this.regressionTables != null && this.regressionTables.size() > 0;
    }

    public RegressionModel addRegressionTables(RegressionTable ... regressionTables) {
        this.getRegressionTables().addAll(Arrays.asList(regressionTables));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations());
        }
        if (status == VisitorAction.CONTINUE && this.hasRegressionTables()) {
            status = PMMLObject.traverse(visitor, this.getRegressionTables());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getModelVerification());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ModelType {
        LINEAR_REGRESSION("linearRegression"),
        STEPWISE_POLYNOMIAL_REGRESSION("stepwisePolynomialRegression"),
        LOGISTIC_REGRESSION("logisticRegression");

        private final String value;

        private ModelType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ModelType fromValue(String v) {
            for (ModelType c : ModelType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

