/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.adapters;

import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.adapters.ValueUtil;

public class IntegerAdapter
extends XmlAdapter<String, Integer> {
    protected static final BigInteger MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    protected static final BigInteger MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);

    public Integer unmarshal(String value) {
        BigInteger integer = DatatypeConverter.parseInteger((String)value);
        if (!ValueUtil.checkRange(integer, MIN_VALUE, MAX_VALUE)) {
            throw new IllegalArgumentException(value);
        }
        return integer.intValue();
    }

    public String marshal(Integer value) {
        if (value == null) {
            return null;
        }
        return DatatypeConverter.printInteger((BigInteger)BigInteger.valueOf(value.intValue()));
    }
}

