/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "fieldColumnPairs", "tableLocator", "inlineTable"})
@XmlRootElement(name="MapValues", namespace="http://www.dmg.org/PMML-4_2")
public class MapValues
extends Expression
implements HasExtensions {
    @XmlAttribute(name="mapMissingTo")
    private String mapMissingTo;
    @XmlAttribute(name="defaultValue")
    private String defaultValue;
    @XmlAttribute(name="outputColumn", required=true)
    private String outputColumn;
    @XmlAttribute(name="dataType")
    @Added(value=Version.PMML_3_1)
    private DataType dataType;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="FieldColumnPair", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_2)
    private List<FieldColumnPair> fieldColumnPairs;
    @XmlElement(name="TableLocator", namespace="http://www.dmg.org/PMML-4_2")
    private TableLocator tableLocator;
    @XmlElement(name="InlineTable", namespace="http://www.dmg.org/PMML-4_2")
    private InlineTable inlineTable;

    public MapValues() {
    }

    public MapValues(String outputColumn) {
        this.outputColumn = outputColumn;
    }

    public String getMapMissingTo() {
        return this.mapMissingTo;
    }

    public MapValues setMapMissingTo(String mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public MapValues setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getOutputColumn() {
        return this.outputColumn;
    }

    public MapValues setOutputColumn(String outputColumn) {
        this.outputColumn = outputColumn;
        return this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MapValues setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<FieldColumnPair> getFieldColumnPairs() {
        if (this.fieldColumnPairs == null) {
            this.fieldColumnPairs = new ArrayList<FieldColumnPair>();
        }
        return this.fieldColumnPairs;
    }

    public TableLocator getTableLocator() {
        return this.tableLocator;
    }

    public MapValues setTableLocator(TableLocator tableLocator) {
        this.tableLocator = tableLocator;
        return this;
    }

    public InlineTable getInlineTable() {
        return this.inlineTable;
    }

    public MapValues setInlineTable(InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public MapValues addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldColumnPairs() {
        return this.fieldColumnPairs != null && this.fieldColumnPairs.size() > 0;
    }

    public MapValues addFieldColumnPairs(FieldColumnPair ... fieldColumnPairs) {
        this.getFieldColumnPairs().addAll(Arrays.asList(fieldColumnPairs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE && this.hasFieldColumnPairs()) {
            status = PMMLObject.traverse(visitor, this.getFieldColumnPairs());
        }
        TableLocator tableLocator = this.getTableLocator();
        if (status == VisitorAction.CONTINUE && tableLocator != null) {
            status = tableLocator.accept(visitor);
        }
        InlineTable inlineTable = this.getInlineTable();
        if (status == VisitorAction.CONTINUE && inlineTable != null) {
            status = inlineTable.accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

