/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Level;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SeasonalityExpoSmooth;
import org.dmg.pmml.TimeSeriesAlgorithm;
import org.dmg.pmml.TimeValue;
import org.dmg.pmml.TrendExpoSmooth;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"level", "trendExpoSmooth", "seasonalityExpoSmooth", "timeValues"})
@XmlRootElement(name="ExponentialSmoothing", namespace="http://www.dmg.org/PMML-4_2")
@Added(value=Version.PMML_4_0)
public class ExponentialSmoothing
extends TimeSeriesAlgorithm {
    @XmlAttribute(name="RMSE")
    private Double rmse;
    @XmlAttribute(name="transformation")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String transformation;
    @XmlElement(name="Level", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private Level level;
    @XmlElement(name="Trend_ExpoSmooth", namespace="http://www.dmg.org/PMML-4_2")
    private TrendExpoSmooth trendExpoSmooth;
    @XmlElement(name="Seasonality_ExpoSmooth", namespace="http://www.dmg.org/PMML-4_2")
    private SeasonalityExpoSmooth seasonalityExpoSmooth;
    @XmlElement(name="TimeValue", namespace="http://www.dmg.org/PMML-4_2")
    private List<TimeValue> timeValues;

    public ExponentialSmoothing() {
    }

    public ExponentialSmoothing(Level level) {
        this.level = level;
    }

    public Double getRMSE() {
        return this.rmse;
    }

    public ExponentialSmoothing setRMSE(Double rmse) {
        this.rmse = rmse;
        return this;
    }

    public String getTransformation() {
        if (this.transformation == null) {
            return "none";
        }
        return this.transformation;
    }

    public ExponentialSmoothing setTransformation(String transformation) {
        this.transformation = transformation;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public ExponentialSmoothing setLevel(Level level) {
        this.level = level;
        return this;
    }

    public TrendExpoSmooth getTrendExpoSmooth() {
        return this.trendExpoSmooth;
    }

    public ExponentialSmoothing setTrendExpoSmooth(TrendExpoSmooth trendExpoSmooth) {
        this.trendExpoSmooth = trendExpoSmooth;
        return this;
    }

    public SeasonalityExpoSmooth getSeasonalityExpoSmooth() {
        return this.seasonalityExpoSmooth;
    }

    public ExponentialSmoothing setSeasonalityExpoSmooth(SeasonalityExpoSmooth seasonalityExpoSmooth) {
        this.seasonalityExpoSmooth = seasonalityExpoSmooth;
        return this;
    }

    public List<TimeValue> getTimeValues() {
        if (this.timeValues == null) {
            this.timeValues = new ArrayList<TimeValue>();
        }
        return this.timeValues;
    }

    public boolean hasTimeValues() {
        return this.timeValues != null && this.timeValues.size() > 0;
    }

    public ExponentialSmoothing addTimeValues(TimeValue ... timeValues) {
        this.getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        Level level = this.getLevel();
        if (status == VisitorAction.CONTINUE && level != null) {
            status = level.accept(visitor);
        }
        TrendExpoSmooth trendExpoSmooth = this.getTrendExpoSmooth();
        if (status == VisitorAction.CONTINUE && trendExpoSmooth != null) {
            status = trendExpoSmooth.accept(visitor);
        }
        SeasonalityExpoSmooth seasonalityExpoSmooth = this.getSeasonalityExpoSmooth();
        if (status == VisitorAction.CONTINUE && seasonalityExpoSmooth != null) {
            status = seasonalityExpoSmooth.accept(visitor);
        }
        if (status == VisitorAction.CONTINUE && this.hasTimeValues()) {
            status = PMMLObject.traverse(visitor, this.getTimeValues());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

